@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RegexPatternSet].
 */
@PulumiTagMarker
public class RegexPatternSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegexPatternSetArgs = RegexPatternSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegexPatternSetArgsBuilder.() -> Unit) {
        val builder = RegexPatternSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RegexPatternSet {
        val builtJavaResource = com.pulumi.aws.wafregional.RegexPatternSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RegexPatternSet(builtJavaResource)
    }
}

/**
 * Provides a WAF Regional Regex Pattern Set Resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.RegexPatternSet;
 * import com.pulumi.aws.wafregional.RegexPatternSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RegexPatternSet("example", RegexPatternSetArgs.builder()
 *             .regexPatternStrings(
 *                 "one",
 *                 "two")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAF Regional Regex Pattern Set using the id. For example:
 * ```sh
 *  $ pulumi import aws:wafregional/regexPatternSet:RegexPatternSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 *
 */
public class RegexPatternSet internal constructor(
    override val javaResource: com.pulumi.aws.wafregional.RegexPatternSet,
) : KotlinCustomResource(javaResource, RegexPatternSetMapper) {
    /**
     * The name or description of the Regex Pattern Set.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A list of regular expression (regex) patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`.
     */
    public val regexPatternStrings: Output<List<String>>?
        get() = javaResource.regexPatternStrings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })
}

public object RegexPatternSetMapper : ResourceMapper<RegexPatternSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.wafregional.RegexPatternSet::class == javaResource::class

    override fun map(javaResource: Resource): RegexPatternSet = RegexPatternSet(
        javaResource as
            com.pulumi.aws.wafregional.RegexPatternSet,
    )
}

/**
 * @see [RegexPatternSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegexPatternSet].
 */
public suspend fun regexPatternSet(
    name: String,
    block: suspend RegexPatternSetResourceBuilder.() -> Unit,
): RegexPatternSet {
    val builder = RegexPatternSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegexPatternSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun regexPatternSet(name: String): RegexPatternSet {
    val builder = RegexPatternSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
