@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.RuleArgs.builder
import com.pulumi.aws.wafregional.kotlin.inputs.RulePredicateArgs
import com.pulumi.aws.wafregional.kotlin.inputs.RulePredicateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an WAF Regional Rule Resource for use with Application Load Balancer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.IpSet;
 * import com.pulumi.aws.wafregional.IpSetArgs;
 * import com.pulumi.aws.wafregional.inputs.IpSetIpSetDescriptorArgs;
 * import com.pulumi.aws.wafregional.Rule;
 * import com.pulumi.aws.wafregional.RuleArgs;
 * import com.pulumi.aws.wafregional.inputs.RulePredicateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipset = new IpSet("ipset", IpSetArgs.builder()
 *             .ipSetDescriptors(IpSetIpSetDescriptorArgs.builder()
 *                 .type("IPV4")
 *                 .value("192.0.7.0/24")
 *                 .build())
 *             .build());
 *         var wafrule = new Rule("wafrule", RuleArgs.builder()
 *             .metricName("tfWAFRule")
 *             .predicates(RulePredicateArgs.builder()
 *                 .type("IPMatch")
 *                 .dataId(ipset.id())
 *                 .negated(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Nested Fields
 * ### `predicate`
 * See the [WAF Documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_Predicate.html) for more information.
 * #### Arguments
 * * `type` - (Required) The type of predicate in a rule. Valid values: `ByteMatch`, `GeoMatch`, `IPMatch`, `RegexMatch`, `SizeConstraint`, `SqlInjectionMatch`, or `XssMatch`
 * * `data_id` - (Required) The unique identifier of a predicate, such as the ID of a `ByteMatchSet` or `IPSet`.
 * * `negated` - (Required) Whether to use the settings or the negated settings that you specified in the objects.
 * ## Import
 * Using `pulumi import`, import WAF Regional Rule using the id. For example:
 * ```sh
 *  $ pulumi import aws:wafregional/rule:Rule wafrule a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property metricName The name or description for the Amazon CloudWatch metric of this rule.
 * @property name The name or description of the rule.
 * @property predicates The objects to include in a rule (documented below).
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RuleArgs(
    public val metricName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val predicates: Output<List<RulePredicateArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafregional.RuleArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.RuleArgs =
        com.pulumi.aws.wafregional.RuleArgs.builder()
            .metricName(metricName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .predicates(
                predicates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RuleArgs].
 */
@PulumiTagMarker
public class RuleArgsBuilder internal constructor() {
    private var metricName: Output<String>? = null

    private var name: Output<String>? = null

    private var predicates: Output<List<RulePredicateArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name or description for the Amazon CloudWatch metric of this rule.
     */
    @JvmName("dvsmmeaamefxrbvc")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The name or description of the rule.
     */
    @JvmName("xvxcgcsskyvxbrwr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The objects to include in a rule (documented below).
     */
    @JvmName("fvxjiqpvgsmaexla")
    public suspend fun predicates(`value`: Output<List<RulePredicateArgs>>) {
        this.predicates = value
    }

    @JvmName("ipxpncceuqngqsgl")
    public suspend fun predicates(vararg values: Output<RulePredicateArgs>) {
        this.predicates = Output.all(values.asList())
    }

    /**
     * @param values The objects to include in a rule (documented below).
     */
    @JvmName("tdofbtnufoixuqda")
    public suspend fun predicates(values: List<Output<RulePredicateArgs>>) {
        this.predicates = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vsbwenrikxjpvpkg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name or description for the Amazon CloudWatch metric of this rule.
     */
    @JvmName("dqmahgrsbvgynilv")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The name or description of the rule.
     */
    @JvmName("npiqrljelqdobwmb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The objects to include in a rule (documented below).
     */
    @JvmName("mwxspyexgwlqcxon")
    public suspend fun predicates(`value`: List<RulePredicateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.predicates = mapped
    }

    /**
     * @param argument The objects to include in a rule (documented below).
     */
    @JvmName("eybsrxyaoujekdso")
    public suspend fun predicates(argument: List<suspend RulePredicateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RulePredicateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.predicates = mapped
    }

    /**
     * @param argument The objects to include in a rule (documented below).
     */
    @JvmName("odaxqksqmvsbrcqw")
    public suspend fun predicates(vararg argument: suspend RulePredicateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RulePredicateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.predicates = mapped
    }

    /**
     * @param argument The objects to include in a rule (documented below).
     */
    @JvmName("hmcgrbosceouwqju")
    public suspend fun predicates(argument: suspend RulePredicateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RulePredicateArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.predicates = mapped
    }

    /**
     * @param values The objects to include in a rule (documented below).
     */
    @JvmName("jgqrhvbyhlcnvrxg")
    public suspend fun predicates(vararg values: RulePredicateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.predicates = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bjgcqdgteuwnevhb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("oyrkbvjftbnqeuho")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RuleArgs = RuleArgs(
        metricName = metricName,
        name = name,
        predicates = predicates,
        tags = tags,
    )
}
