@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.RuleGroupArgs.builder
import com.pulumi.aws.wafregional.kotlin.inputs.RuleGroupActivatedRuleArgs
import com.pulumi.aws.wafregional.kotlin.inputs.RuleGroupActivatedRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a WAF Regional Rule Group Resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.Rule;
 * import com.pulumi.aws.wafregional.RuleArgs;
 * import com.pulumi.aws.wafregional.RuleGroup;
 * import com.pulumi.aws.wafregional.RuleGroupArgs;
 * import com.pulumi.aws.wafregional.inputs.RuleGroupActivatedRuleArgs;
 * import com.pulumi.aws.wafregional.inputs.RuleGroupActivatedRuleActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRule = new Rule("exampleRule", RuleArgs.builder()
 *             .metricName("example")
 *             .build());
 *         var exampleRuleGroup = new RuleGroup("exampleRuleGroup", RuleGroupArgs.builder()
 *             .metricName("example")
 *             .activatedRules(RuleGroupActivatedRuleArgs.builder()
 *                 .action(RuleGroupActivatedRuleActionArgs.builder()
 *                     .type("COUNT")
 *                     .build())
 *                 .priority(50)
 *                 .ruleId(exampleRule.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAF Regional Rule Group using the id. For example:
 * ```sh
 *  $ pulumi import aws:wafregional/ruleGroup:RuleGroup example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property activatedRules A list of activated rules, see below
 * @property metricName A friendly name for the metrics from the rule group
 * @property name A friendly name of the rule group
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RuleGroupArgs(
    public val activatedRules: Output<List<RuleGroupActivatedRuleArgs>>? = null,
    public val metricName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafregional.RuleGroupArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.RuleGroupArgs =
        com.pulumi.aws.wafregional.RuleGroupArgs.builder()
            .activatedRules(
                activatedRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .metricName(metricName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RuleGroupArgs].
 */
@PulumiTagMarker
public class RuleGroupArgsBuilder internal constructor() {
    private var activatedRules: Output<List<RuleGroupActivatedRuleArgs>>? = null

    private var metricName: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A list of activated rules, see below
     */
    @JvmName("cpisrthfelgkjofp")
    public suspend fun activatedRules(`value`: Output<List<RuleGroupActivatedRuleArgs>>) {
        this.activatedRules = value
    }

    @JvmName("jkhhjpduajnthhnc")
    public suspend fun activatedRules(vararg values: Output<RuleGroupActivatedRuleArgs>) {
        this.activatedRules = Output.all(values.asList())
    }

    /**
     * @param values A list of activated rules, see below
     */
    @JvmName("bykqmhlobsujsbas")
    public suspend fun activatedRules(values: List<Output<RuleGroupActivatedRuleArgs>>) {
        this.activatedRules = Output.all(values)
    }

    /**
     * @param value A friendly name for the metrics from the rule group
     */
    @JvmName("bydcwnlocfdnameq")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value A friendly name of the rule group
     */
    @JvmName("ayejhmvxjqxajhkd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tlqmqqcnjjcqjjmt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of activated rules, see below
     */
    @JvmName("aewckluntgbtqgav")
    public suspend fun activatedRules(`value`: List<RuleGroupActivatedRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activatedRules = mapped
    }

    /**
     * @param argument A list of activated rules, see below
     */
    @JvmName("vodwydcpomlkkwan")
    public suspend
    fun activatedRules(argument: List<suspend RuleGroupActivatedRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupActivatedRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.activatedRules = mapped
    }

    /**
     * @param argument A list of activated rules, see below
     */
    @JvmName("ehcnjvbyqvpkyjxn")
    public suspend fun activatedRules(
        vararg
        argument: suspend RuleGroupActivatedRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupActivatedRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.activatedRules = mapped
    }

    /**
     * @param argument A list of activated rules, see below
     */
    @JvmName("hbimbcaujhswyhrd")
    public suspend
    fun activatedRules(argument: suspend RuleGroupActivatedRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuleGroupActivatedRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.activatedRules = mapped
    }

    /**
     * @param values A list of activated rules, see below
     */
    @JvmName("aqbiqfyfbebayfjv")
    public suspend fun activatedRules(vararg values: RuleGroupActivatedRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activatedRules = mapped
    }

    /**
     * @param value A friendly name for the metrics from the rule group
     */
    @JvmName("lentqlppgnlgvqwa")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value A friendly name of the rule group
     */
    @JvmName("xgsroenjklqagapy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ndnkickcgbukdhvt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("likatwidymlryerp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RuleGroupArgs = RuleGroupArgs(
        activatedRules = activatedRules,
        metricName = metricName,
        name = name,
        tags = tags,
    )
}
