@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.kotlin.outputs.SizeConstraintSetSizeConstraint
import com.pulumi.aws.wafregional.kotlin.outputs.SizeConstraintSetSizeConstraint.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SizeConstraintSet].
 */
@PulumiTagMarker
public class SizeConstraintSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SizeConstraintSetArgs = SizeConstraintSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SizeConstraintSetArgsBuilder.() -> Unit) {
        val builder = SizeConstraintSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SizeConstraintSet {
        val builtJavaResource = com.pulumi.aws.wafregional.SizeConstraintSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SizeConstraintSet(builtJavaResource)
    }
}

/**
 * Provides a WAF Regional Size Constraint Set Resource for use with Application Load Balancer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.SizeConstraintSet;
 * import com.pulumi.aws.wafregional.SizeConstraintSetArgs;
 * import com.pulumi.aws.wafregional.inputs.SizeConstraintSetSizeConstraintArgs;
 * import com.pulumi.aws.wafregional.inputs.SizeConstraintSetSizeConstraintFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sizeConstraintSet = new SizeConstraintSet("sizeConstraintSet", SizeConstraintSetArgs.builder()
 *             .sizeConstraints(SizeConstraintSetSizeConstraintArgs.builder()
 *                 .comparisonOperator("EQ")
 *                 .fieldToMatch(SizeConstraintSetSizeConstraintFieldToMatchArgs.builder()
 *                     .type("BODY")
 *                     .build())
 *                 .size("4096")
 *                 .textTransformation("NONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAF Size Constraint Set using the id. For example:
 * ```sh
 *  $ pulumi import aws:wafregional/sizeConstraintSet:SizeConstraintSet size_constraint_set a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 *
 */
public class SizeConstraintSet internal constructor(
    override val javaResource: com.pulumi.aws.wafregional.SizeConstraintSet,
) : KotlinCustomResource(javaResource, SizeConstraintSetMapper) {
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name or description of the Size Constraint Set.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the parts of web requests that you want to inspect the size of.
     */
    public val sizeConstraints: Output<List<SizeConstraintSetSizeConstraint>>?
        get() = javaResource.sizeConstraints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })
}

public object SizeConstraintSetMapper : ResourceMapper<SizeConstraintSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.wafregional.SizeConstraintSet::class == javaResource::class

    override fun map(javaResource: Resource): SizeConstraintSet = SizeConstraintSet(
        javaResource as
            com.pulumi.aws.wafregional.SizeConstraintSet,
    )
}

/**
 * @see [SizeConstraintSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SizeConstraintSet].
 */
public suspend fun sizeConstraintSet(
    name: String,
    block: suspend SizeConstraintSetResourceBuilder.() -> Unit,
): SizeConstraintSet {
    val builder = SizeConstraintSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SizeConstraintSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sizeConstraintSet(name: String): SizeConstraintSet {
    val builder = SizeConstraintSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
