@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.SizeConstraintSetArgs.builder
import com.pulumi.aws.wafregional.kotlin.inputs.SizeConstraintSetSizeConstraintArgs
import com.pulumi.aws.wafregional.kotlin.inputs.SizeConstraintSetSizeConstraintArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a WAF Regional Size Constraint Set Resource for use with Application Load Balancer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.SizeConstraintSet;
 * import com.pulumi.aws.wafregional.SizeConstraintSetArgs;
 * import com.pulumi.aws.wafregional.inputs.SizeConstraintSetSizeConstraintArgs;
 * import com.pulumi.aws.wafregional.inputs.SizeConstraintSetSizeConstraintFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sizeConstraintSet = new SizeConstraintSet("sizeConstraintSet", SizeConstraintSetArgs.builder()
 *             .sizeConstraints(SizeConstraintSetSizeConstraintArgs.builder()
 *                 .comparisonOperator("EQ")
 *                 .fieldToMatch(SizeConstraintSetSizeConstraintFieldToMatchArgs.builder()
 *                     .type("BODY")
 *                     .build())
 *                 .size("4096")
 *                 .textTransformation("NONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAF Size Constraint Set using the id. For example:
 * ```sh
 *  $ pulumi import aws:wafregional/sizeConstraintSet:SizeConstraintSet size_constraint_set a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property name The name or description of the Size Constraint Set.
 * @property sizeConstraints Specifies the parts of web requests that you want to inspect the size of.
 */
public data class SizeConstraintSetArgs(
    public val name: Output<String>? = null,
    public val sizeConstraints: Output<List<SizeConstraintSetSizeConstraintArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafregional.SizeConstraintSetArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.SizeConstraintSetArgs =
        com.pulumi.aws.wafregional.SizeConstraintSetArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .sizeConstraints(
                sizeConstraints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SizeConstraintSetArgs].
 */
@PulumiTagMarker
public class SizeConstraintSetArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var sizeConstraints: Output<List<SizeConstraintSetSizeConstraintArgs>>? = null

    /**
     * @param value The name or description of the Size Constraint Set.
     */
    @JvmName("lykrxbsltmjxcwjy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the parts of web requests that you want to inspect the size of.
     */
    @JvmName("acfktldubxpjgkwh")
    public suspend fun sizeConstraints(`value`: Output<List<SizeConstraintSetSizeConstraintArgs>>) {
        this.sizeConstraints = value
    }

    @JvmName("kctiievtawdfefgu")
    public suspend fun sizeConstraints(vararg values: Output<SizeConstraintSetSizeConstraintArgs>) {
        this.sizeConstraints = Output.all(values.asList())
    }

    /**
     * @param values Specifies the parts of web requests that you want to inspect the size of.
     */
    @JvmName("icxtmhubfhkidwvm")
    public suspend fun sizeConstraints(values: List<Output<SizeConstraintSetSizeConstraintArgs>>) {
        this.sizeConstraints = Output.all(values)
    }

    /**
     * @param value The name or description of the Size Constraint Set.
     */
    @JvmName("ypbcefjgiigyagbt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the parts of web requests that you want to inspect the size of.
     */
    @JvmName("xrfgebghnryeqqby")
    public suspend fun sizeConstraints(`value`: List<SizeConstraintSetSizeConstraintArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeConstraints = mapped
    }

    /**
     * @param argument Specifies the parts of web requests that you want to inspect the size of.
     */
    @JvmName("swkwibpvmbfxxqyt")
    public suspend
    fun sizeConstraints(argument: List<suspend SizeConstraintSetSizeConstraintArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SizeConstraintSetSizeConstraintArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sizeConstraints = mapped
    }

    /**
     * @param argument Specifies the parts of web requests that you want to inspect the size of.
     */
    @JvmName("tqanyqqblsuwkyct")
    public suspend fun sizeConstraints(
        vararg
        argument: suspend SizeConstraintSetSizeConstraintArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SizeConstraintSetSizeConstraintArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sizeConstraints = mapped
    }

    /**
     * @param argument Specifies the parts of web requests that you want to inspect the size of.
     */
    @JvmName("omuhbtabucxwbjbh")
    public suspend
    fun sizeConstraints(argument: suspend SizeConstraintSetSizeConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SizeConstraintSetSizeConstraintArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sizeConstraints = mapped
    }

    /**
     * @param values Specifies the parts of web requests that you want to inspect the size of.
     */
    @JvmName("xqwrrccexrtjmjjg")
    public suspend fun sizeConstraints(vararg values: SizeConstraintSetSizeConstraintArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizeConstraints = mapped
    }

    internal fun build(): SizeConstraintSetArgs = SizeConstraintSetArgs(
        name = name,
        sizeConstraints = sizeConstraints,
    )
}
