@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.kotlin.outputs.SqlInjectionMatchSetSqlInjectionMatchTuple
import com.pulumi.aws.wafregional.kotlin.outputs.SqlInjectionMatchSetSqlInjectionMatchTuple.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SqlInjectionMatchSet].
 */
@PulumiTagMarker
public class SqlInjectionMatchSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlInjectionMatchSetArgs = SqlInjectionMatchSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlInjectionMatchSetArgsBuilder.() -> Unit) {
        val builder = SqlInjectionMatchSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SqlInjectionMatchSet {
        val builtJavaResource = com.pulumi.aws.wafregional.SqlInjectionMatchSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SqlInjectionMatchSet(builtJavaResource)
    }
}

/**
 * Provides a WAF Regional SQL Injection Match Set Resource for use with Application Load Balancer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.SqlInjectionMatchSet;
 * import com.pulumi.aws.wafregional.SqlInjectionMatchSetArgs;
 * import com.pulumi.aws.wafregional.inputs.SqlInjectionMatchSetSqlInjectionMatchTupleArgs;
 * import com.pulumi.aws.wafregional.inputs.SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlInjectionMatchSet = new SqlInjectionMatchSet("sqlInjectionMatchSet", SqlInjectionMatchSetArgs.builder()
 *             .sqlInjectionMatchTuples(SqlInjectionMatchSetSqlInjectionMatchTupleArgs.builder()
 *                 .fieldToMatch(SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs.builder()
 *                     .type("QUERY_STRING")
 *                     .build())
 *                 .textTransformation("URL_DECODE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAF Regional Sql Injection Match Set using the id. For example:
 * ```sh
 *  $ pulumi import aws:wafregional/sqlInjectionMatchSet:SqlInjectionMatchSet sql_injection_match_set a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 *
 */
public class SqlInjectionMatchSet internal constructor(
    override val javaResource: com.pulumi.aws.wafregional.SqlInjectionMatchSet,
) : KotlinCustomResource(javaResource, SqlInjectionMatchSetMapper) {
    /**
     * The name or description of the SizeConstraintSet.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    public val sqlInjectionMatchTuples: Output<List<SqlInjectionMatchSetSqlInjectionMatchTuple>>?
        get() = javaResource.sqlInjectionMatchTuples().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })
}

public object SqlInjectionMatchSetMapper : ResourceMapper<SqlInjectionMatchSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.wafregional.SqlInjectionMatchSet::class == javaResource::class

    override fun map(javaResource: Resource): SqlInjectionMatchSet = SqlInjectionMatchSet(
        javaResource
            as com.pulumi.aws.wafregional.SqlInjectionMatchSet,
    )
}

/**
 * @see [SqlInjectionMatchSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlInjectionMatchSet].
 */
public suspend fun sqlInjectionMatchSet(
    name: String,
    block: suspend SqlInjectionMatchSetResourceBuilder.() -> Unit,
): SqlInjectionMatchSet {
    val builder = SqlInjectionMatchSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlInjectionMatchSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlInjectionMatchSet(name: String): SqlInjectionMatchSet {
    val builder = SqlInjectionMatchSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
