@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.SqlInjectionMatchSetArgs.builder
import com.pulumi.aws.wafregional.kotlin.inputs.SqlInjectionMatchSetSqlInjectionMatchTupleArgs
import com.pulumi.aws.wafregional.kotlin.inputs.SqlInjectionMatchSetSqlInjectionMatchTupleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a WAF Regional SQL Injection Match Set Resource for use with Application Load Balancer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.SqlInjectionMatchSet;
 * import com.pulumi.aws.wafregional.SqlInjectionMatchSetArgs;
 * import com.pulumi.aws.wafregional.inputs.SqlInjectionMatchSetSqlInjectionMatchTupleArgs;
 * import com.pulumi.aws.wafregional.inputs.SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlInjectionMatchSet = new SqlInjectionMatchSet("sqlInjectionMatchSet", SqlInjectionMatchSetArgs.builder()
 *             .sqlInjectionMatchTuples(SqlInjectionMatchSetSqlInjectionMatchTupleArgs.builder()
 *                 .fieldToMatch(SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs.builder()
 *                     .type("QUERY_STRING")
 *                     .build())
 *                 .textTransformation("URL_DECODE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAF Regional Sql Injection Match Set using the id. For example:
 * ```sh
 *  $ pulumi import aws:wafregional/sqlInjectionMatchSet:SqlInjectionMatchSet sql_injection_match_set a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property name The name or description of the SizeConstraintSet.
 * @property sqlInjectionMatchTuples The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
 */
public data class SqlInjectionMatchSetArgs(
    public val name: Output<String>? = null,
    public val sqlInjectionMatchTuples: Output<List<SqlInjectionMatchSetSqlInjectionMatchTupleArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.wafregional.SqlInjectionMatchSetArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.SqlInjectionMatchSetArgs =
        com.pulumi.aws.wafregional.SqlInjectionMatchSetArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .sqlInjectionMatchTuples(
                sqlInjectionMatchTuples?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SqlInjectionMatchSetArgs].
 */
@PulumiTagMarker
public class SqlInjectionMatchSetArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var sqlInjectionMatchTuples: Output<List<SqlInjectionMatchSetSqlInjectionMatchTupleArgs>>? =
        null

    /**
     * @param value The name or description of the SizeConstraintSet.
     */
    @JvmName("hyfudisarllagoxa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    @JvmName("takstosidwhnepnm")
    public suspend
    fun sqlInjectionMatchTuples(`value`: Output<List<SqlInjectionMatchSetSqlInjectionMatchTupleArgs>>) {
        this.sqlInjectionMatchTuples = value
    }

    @JvmName("upbfdtolppniouya")
    public suspend fun sqlInjectionMatchTuples(
        vararg
        values: Output<SqlInjectionMatchSetSqlInjectionMatchTupleArgs>,
    ) {
        this.sqlInjectionMatchTuples = Output.all(values.asList())
    }

    /**
     * @param values The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    @JvmName("ofmjwyxsrwdltqms")
    public suspend
    fun sqlInjectionMatchTuples(values: List<Output<SqlInjectionMatchSetSqlInjectionMatchTupleArgs>>) {
        this.sqlInjectionMatchTuples = Output.all(values)
    }

    /**
     * @param value The name or description of the SizeConstraintSet.
     */
    @JvmName("bqnkljxxkfahcmcv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    @JvmName("gxtcxxrfcgryahki")
    public suspend
    fun sqlInjectionMatchTuples(`value`: List<SqlInjectionMatchSetSqlInjectionMatchTupleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlInjectionMatchTuples = mapped
    }

    /**
     * @param argument The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    @JvmName("ynpebbypmqbtwalt")
    public suspend
    fun sqlInjectionMatchTuples(argument: List<suspend SqlInjectionMatchSetSqlInjectionMatchTupleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SqlInjectionMatchSetSqlInjectionMatchTupleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sqlInjectionMatchTuples = mapped
    }

    /**
     * @param argument The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    @JvmName("kpbaunumdcxeqffy")
    public suspend fun sqlInjectionMatchTuples(
        vararg
        argument: suspend SqlInjectionMatchSetSqlInjectionMatchTupleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SqlInjectionMatchSetSqlInjectionMatchTupleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sqlInjectionMatchTuples = mapped
    }

    /**
     * @param argument The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    @JvmName("ntufjxyqlihxmwnl")
    public suspend
    fun sqlInjectionMatchTuples(argument: suspend SqlInjectionMatchSetSqlInjectionMatchTupleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SqlInjectionMatchSetSqlInjectionMatchTupleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sqlInjectionMatchTuples = mapped
    }

    /**
     * @param values The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    @JvmName("vcfwjbwrkmowkqvx")
    public suspend fun sqlInjectionMatchTuples(
        vararg
        values: SqlInjectionMatchSetSqlInjectionMatchTupleArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlInjectionMatchTuples = mapped
    }

    internal fun build(): SqlInjectionMatchSetArgs = SqlInjectionMatchSetArgs(
        name = name,
        sqlInjectionMatchTuples = sqlInjectionMatchTuples,
    )
}
