@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebAclAssociation].
 */
@PulumiTagMarker
public class WebAclAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAclAssociationArgs = WebAclAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAclAssociationArgsBuilder.() -> Unit) {
        val builder = WebAclAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebAclAssociation {
        val builtJavaResource = com.pulumi.aws.wafregional.WebAclAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WebAclAssociation(builtJavaResource)
    }
}

/**
 * Manages an association with WAF Regional Web ACL.
 * > **Note:** An Application Load Balancer can only be associated with one WAF Regional WebACL.
 * ## Example Usage
 * ### Application Load Balancer Association
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.IpSet;
 * import com.pulumi.aws.wafregional.IpSetArgs;
 * import com.pulumi.aws.wafregional.inputs.IpSetIpSetDescriptorArgs;
 * import com.pulumi.aws.wafregional.Rule;
 * import com.pulumi.aws.wafregional.RuleArgs;
 * import com.pulumi.aws.wafregional.inputs.RulePredicateArgs;
 * import com.pulumi.aws.wafregional.WebAcl;
 * import com.pulumi.aws.wafregional.WebAclArgs;
 * import com.pulumi.aws.wafregional.inputs.WebAclDefaultActionArgs;
 * import com.pulumi.aws.wafregional.inputs.WebAclRuleArgs;
 * import com.pulumi.aws.wafregional.inputs.WebAclRuleActionArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.alb.LoadBalancer;
 * import com.pulumi.aws.alb.LoadBalancerArgs;
 * import com.pulumi.aws.wafregional.WebAclAssociation;
 * import com.pulumi.aws.wafregional.WebAclAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipset = new IpSet("ipset", IpSetArgs.builder()
 *             .ipSetDescriptors(IpSetIpSetDescriptorArgs.builder()
 *                 .type("IPV4")
 *                 .value("192.0.7.0/24")
 *                 .build())
 *             .build());
 *         var fooRule = new Rule("fooRule", RuleArgs.builder()
 *             .metricName("tfWAFRule")
 *             .predicates(RulePredicateArgs.builder()
 *                 .dataId(ipset.id())
 *                 .negated(false)
 *                 .type("IPMatch")
 *                 .build())
 *             .build());
 *         var fooWebAcl = new WebAcl("fooWebAcl", WebAclArgs.builder()
 *             .metricName("foo")
 *             .defaultAction(WebAclDefaultActionArgs.builder()
 *                 .type("ALLOW")
 *                 .build())
 *             .rules(WebAclRuleArgs.builder()
 *                 .action(WebAclRuleActionArgs.builder()
 *                     .type("BLOCK")
 *                     .build())
 *                 .priority(1)
 *                 .ruleId(fooRule.id())
 *                 .build())
 *             .build());
 *         var fooVpc = new Vpc("fooVpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build());
 *         final var available = AwsFunctions.getAvailabilityZones();
 *         var fooSubnet = new Subnet("fooSubnet", SubnetArgs.builder()
 *             .vpcId(fooVpc.id())
 *             .cidrBlock("10.1.1.0/24")
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .build());
 *         var bar = new Subnet("bar", SubnetArgs.builder()
 *             .vpcId(fooVpc.id())
 *             .cidrBlock("10.1.2.0/24")
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[1]))
 *             .build());
 *         var fooLoadBalancer = new LoadBalancer("fooLoadBalancer", LoadBalancerArgs.builder()
 *             .internal(true)
 *             .subnets(
 *                 fooSubnet.id(),
 *                 bar.id())
 *             .build());
 *         var fooWebAclAssociation = new WebAclAssociation("fooWebAclAssociation", WebAclAssociationArgs.builder()
 *             .resourceArn(fooLoadBalancer.arn())
 *             .webAclId(fooWebAcl.id())
 *             .build());
 *     }
 * }
 * ```
 * ### API Gateway Association
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.IpSet;
 * import com.pulumi.aws.wafregional.IpSetArgs;
 * import com.pulumi.aws.wafregional.inputs.IpSetIpSetDescriptorArgs;
 * import com.pulumi.aws.wafregional.Rule;
 * import com.pulumi.aws.wafregional.RuleArgs;
 * import com.pulumi.aws.wafregional.inputs.RulePredicateArgs;
 * import com.pulumi.aws.wafregional.WebAcl;
 * import com.pulumi.aws.wafregional.WebAclArgs;
 * import com.pulumi.aws.wafregional.inputs.WebAclDefaultActionArgs;
 * import com.pulumi.aws.wafregional.inputs.WebAclRuleArgs;
 * import com.pulumi.aws.wafregional.inputs.WebAclRuleActionArgs;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Deployment;
 * import com.pulumi.aws.apigateway.DeploymentArgs;
 * import com.pulumi.aws.apigateway.Stage;
 * import com.pulumi.aws.apigateway.StageArgs;
 * import com.pulumi.aws.wafregional.WebAclAssociation;
 * import com.pulumi.aws.wafregional.WebAclAssociationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipset = new IpSet("ipset", IpSetArgs.builder()
 *             .ipSetDescriptors(IpSetIpSetDescriptorArgs.builder()
 *                 .type("IPV4")
 *                 .value("192.0.7.0/24")
 *                 .build())
 *             .build());
 *         var fooRule = new Rule("fooRule", RuleArgs.builder()
 *             .metricName("tfWAFRule")
 *             .predicates(RulePredicateArgs.builder()
 *                 .dataId(ipset.id())
 *                 .negated(false)
 *                 .type("IPMatch")
 *                 .build())
 *             .build());
 *         var fooWebAcl = new WebAcl("fooWebAcl", WebAclArgs.builder()
 *             .metricName("foo")
 *             .defaultAction(WebAclDefaultActionArgs.builder()
 *                 .type("ALLOW")
 *                 .build())
 *             .rules(WebAclRuleArgs.builder()
 *                 .action(WebAclRuleActionArgs.builder()
 *                     .type("BLOCK")
 *                     .build())
 *                 .priority(1)
 *                 .ruleId(fooRule.id())
 *                 .build())
 *             .build());
 *         var exampleRestApi = new RestApi("exampleRestApi", RestApiArgs.builder()
 *             .body(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("openapi", "3.0.1"),
 *                     jsonProperty("info", jsonObject(
 *                         jsonProperty("title", "example"),
 *                         jsonProperty("version", "1.0")
 *                     )),
 *                     jsonProperty("paths", jsonObject(
 *                         jsonProperty("/path1", jsonObject(
 *                             jsonProperty("get", jsonObject(
 *                                 jsonProperty("x-amazon-apigateway-integration", jsonObject(
 *                                     jsonProperty("httpMethod", "GET"),
 *                                     jsonProperty("payloadFormatVersion", "1.0"),
 *                                     jsonProperty("type", "HTTP_PROXY"),
 *                                     jsonProperty("uri", "https://ip-ranges.amazonaws.com/ip-ranges.json")
 *                                 ))
 *                             ))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *         var exampleDeployment = new Deployment("exampleDeployment", DeploymentArgs.builder()
 *             .restApi(exampleRestApi.id())
 *             .triggers(Map.of("redeployment", exampleRestApi.body().applyValue(body -> serializeJson(
 *                 body)).applyValue(toJSON -> computeSHA1(toJSON))))
 *             .build());
 *         var exampleStage = new Stage("exampleStage", StageArgs.builder()
 *             .deployment(exampleDeployment.id())
 *             .restApi(exampleRestApi.id())
 *             .stageName("example")
 *             .build());
 *         var association = new WebAclAssociation("association", WebAclAssociationArgs.builder()
 *             .resourceArn(exampleStage.arn())
 *             .webAclId(fooWebAcl.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAF Regional Web ACL Association using their `web_acl_id:resource_arn`. For example:
 * ```sh
 *  $ pulumi import aws:wafregional/webAclAssociation:WebAclAssociation foo web_acl_id:resource_arn
 * ```
 *
 */
public class WebAclAssociation internal constructor(
    override val javaResource: com.pulumi.aws.wafregional.WebAclAssociation,
) : KotlinCustomResource(javaResource, WebAclAssociationMapper) {
    /**
     * ARN of the resource to associate with. For example, an Application Load Balancer or API Gateway Stage.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the WAF Regional WebACL to create an association.
     */
    public val webAclId: Output<String>
        get() = javaResource.webAclId().applyValue({ args0 -> args0 })
}

public object WebAclAssociationMapper : ResourceMapper<WebAclAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.wafregional.WebAclAssociation::class == javaResource::class

    override fun map(javaResource: Resource): WebAclAssociation = WebAclAssociation(
        javaResource as
            com.pulumi.aws.wafregional.WebAclAssociation,
    )
}

/**
 * @see [WebAclAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAclAssociation].
 */
public suspend fun webAclAssociation(
    name: String,
    block: suspend WebAclAssociationResourceBuilder.() -> Unit,
): WebAclAssociation {
    val builder = WebAclAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAclAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAclAssociation(name: String): WebAclAssociation {
    val builder = WebAclAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
