@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.inputs

import com.pulumi.aws.wafregional.inputs.GeoMatchSetGeoMatchConstraintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type The type of geographical area you want AWS WAF to search for. Currently Country is the only valid value.
 * @property value The country that you want AWS WAF to search for.
 * This is the two-letter country code, e.g., `US`, `CA`, `RU`, `CN`, etc.
 * See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchConstraint.html) for all supported values.
 */
public data class GeoMatchSetGeoMatchConstraintArgs(
    public val type: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.wafregional.inputs.GeoMatchSetGeoMatchConstraintArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.inputs.GeoMatchSetGeoMatchConstraintArgs =
        com.pulumi.aws.wafregional.inputs.GeoMatchSetGeoMatchConstraintArgs.builder()
            .type(type.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GeoMatchSetGeoMatchConstraintArgs].
 */
@PulumiTagMarker
public class GeoMatchSetGeoMatchConstraintArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The type of geographical area you want AWS WAF to search for. Currently Country is the only valid value.
     */
    @JvmName("xxjdooiawwjnncjg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The country that you want AWS WAF to search for.
     * This is the two-letter country code, e.g., `US`, `CA`, `RU`, `CN`, etc.
     * See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchConstraint.html) for all supported values.
     */
    @JvmName("rkyqrympgdneafnk")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The type of geographical area you want AWS WAF to search for. Currently Country is the only valid value.
     */
    @JvmName("kntmrdcenkjpfsdg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The country that you want AWS WAF to search for.
     * This is the two-letter country code, e.g., `US`, `CA`, `RU`, `CN`, etc.
     * See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchConstraint.html) for all supported values.
     */
    @JvmName("rsgttrdkxwcywxkp")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): GeoMatchSetGeoMatchConstraintArgs = GeoMatchSetGeoMatchConstraintArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
