@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.inputs

import com.pulumi.aws.wafregional.inputs.GetRateBasedModPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRateBasedMod.
 * @property name Name of the WAF Regional rate based rule.
 */
public data class GetRateBasedModPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.wafregional.inputs.GetRateBasedModPlainArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.inputs.GetRateBasedModPlainArgs =
        com.pulumi.aws.wafregional.inputs.GetRateBasedModPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRateBasedModPlainArgs].
 */
@PulumiTagMarker
public class GetRateBasedModPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the WAF Regional rate based rule.
     */
    @JvmName("bufmrvkadviyxcks")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetRateBasedModPlainArgs = GetRateBasedModPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
