@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.inputs

import com.pulumi.aws.wafregional.inputs.GetSubscribedRuleGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSubscribedRuleGroup.
 * @property metricName Name of the WAF rule group.
 * @property name Name of the WAF rule group.
 */
public data class GetSubscribedRuleGroupPlainArgs(
    public val metricName: String? = null,
    public val name: String? = null,
) : ConvertibleToJava<com.pulumi.aws.wafregional.inputs.GetSubscribedRuleGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.inputs.GetSubscribedRuleGroupPlainArgs =
        com.pulumi.aws.wafregional.inputs.GetSubscribedRuleGroupPlainArgs.builder()
            .metricName(metricName?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSubscribedRuleGroupPlainArgs].
 */
@PulumiTagMarker
public class GetSubscribedRuleGroupPlainArgsBuilder internal constructor() {
    private var metricName: String? = null

    private var name: String? = null

    /**
     * @param value Name of the WAF rule group.
     */
    @JvmName("ekmbbwdjqyupmgmd")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.metricName = mapped
    }

    /**
     * @param value Name of the WAF rule group.
     */
    @JvmName("nhbejykukudvjcmw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetSubscribedRuleGroupPlainArgs = GetSubscribedRuleGroupPlainArgs(
        metricName = metricName,
        name = name,
    )
}
