@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.inputs

import com.pulumi.aws.wafregional.inputs.IpSetIpSetDescriptorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type The string like IPV4 or IPV6.
 * @property value The CIDR notation.
 */
public data class IpSetIpSetDescriptorArgs(
    public val type: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.wafregional.inputs.IpSetIpSetDescriptorArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.inputs.IpSetIpSetDescriptorArgs =
        com.pulumi.aws.wafregional.inputs.IpSetIpSetDescriptorArgs.builder()
            .type(type.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpSetIpSetDescriptorArgs].
 */
@PulumiTagMarker
public class IpSetIpSetDescriptorArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The string like IPV4 or IPV6.
     */
    @JvmName("kqlqihhysmrofdlw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The CIDR notation.
     */
    @JvmName("orlaqlgepfkcvnay")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The string like IPV4 or IPV6.
     */
    @JvmName("vlogpqjqfccxqeqa")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The CIDR notation.
     */
    @JvmName("athcddradpuxarbj")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): IpSetIpSetDescriptorArgs = IpSetIpSetDescriptorArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
