@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.inputs

import com.pulumi.aws.wafregional.inputs.RegexMatchSetRegexMatchTupleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatch The part of a web request that you want to search, such as a specified header or a query string.
 * @property regexPatternSetId The ID of a Regex Pattern Set.
 * @property textTransformation Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
 * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
 * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-TextTransformation)
 * for all supported values.
 */
public data class RegexMatchSetRegexMatchTupleArgs(
    public val fieldToMatch: Output<RegexMatchSetRegexMatchTupleFieldToMatchArgs>,
    public val regexPatternSetId: Output<String>,
    public val textTransformation: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.wafregional.inputs.RegexMatchSetRegexMatchTupleArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.inputs.RegexMatchSetRegexMatchTupleArgs =
        com.pulumi.aws.wafregional.inputs.RegexMatchSetRegexMatchTupleArgs.builder()
            .fieldToMatch(fieldToMatch.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .regexPatternSetId(regexPatternSetId.applyValue({ args0 -> args0 }))
            .textTransformation(textTransformation.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegexMatchSetRegexMatchTupleArgs].
 */
@PulumiTagMarker
public class RegexMatchSetRegexMatchTupleArgsBuilder internal constructor() {
    private var fieldToMatch: Output<RegexMatchSetRegexMatchTupleFieldToMatchArgs>? = null

    private var regexPatternSetId: Output<String>? = null

    private var textTransformation: Output<String>? = null

    /**
     * @param value The part of a web request that you want to search, such as a specified header or a query string.
     */
    @JvmName("cihvtyhluvnsnhcv")
    public suspend fun fieldToMatch(`value`: Output<RegexMatchSetRegexMatchTupleFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value The ID of a Regex Pattern Set.
     */
    @JvmName("oofxpqfwwasksmeg")
    public suspend fun regexPatternSetId(`value`: Output<String>) {
        this.regexPatternSetId = value
    }

    /**
     * @param value Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
     * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
     * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-TextTransformation)
     * for all supported values.
     */
    @JvmName("tvmdcicoifoloegf")
    public suspend fun textTransformation(`value`: Output<String>) {
        this.textTransformation = value
    }

    /**
     * @param value The part of a web request that you want to search, such as a specified header or a query string.
     */
    @JvmName("gycqoadnqgdgvmeg")
    public suspend fun fieldToMatch(`value`: RegexMatchSetRegexMatchTupleFieldToMatchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument The part of a web request that you want to search, such as a specified header or a query string.
     */
    @JvmName("xnokeowhjhiujlvx")
    public suspend
    fun fieldToMatch(argument: suspend RegexMatchSetRegexMatchTupleFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped = RegexMatchSetRegexMatchTupleFieldToMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value The ID of a Regex Pattern Set.
     */
    @JvmName("nnsocsslxvuekugy")
    public suspend fun regexPatternSetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regexPatternSetId = mapped
    }

    /**
     * @param value Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
     * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
     * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-TextTransformation)
     * for all supported values.
     */
    @JvmName("fkijbmfpsecptdkj")
    public suspend fun textTransformation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformation = mapped
    }

    internal fun build(): RegexMatchSetRegexMatchTupleArgs = RegexMatchSetRegexMatchTupleArgs(
        fieldToMatch = fieldToMatch ?: throw PulumiNullFieldException("fieldToMatch"),
        regexPatternSetId = regexPatternSetId ?: throw PulumiNullFieldException("regexPatternSetId"),
        textTransformation = textTransformation ?: throw PulumiNullFieldException("textTransformation"),
    )
}
