@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.inputs

import com.pulumi.aws.wafregional.inputs.RuleGroupActivatedRuleActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type The rule type, either `REGULAR`, `RATE_BASED`, or `GROUP`. Defaults to `REGULAR`.
 */
public data class RuleGroupActivatedRuleActionArgs(
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.wafregional.inputs.RuleGroupActivatedRuleActionArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.inputs.RuleGroupActivatedRuleActionArgs =
        com.pulumi.aws.wafregional.inputs.RuleGroupActivatedRuleActionArgs.builder()
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupActivatedRuleActionArgs].
 */
@PulumiTagMarker
public class RuleGroupActivatedRuleActionArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value The rule type, either `REGULAR`, `RATE_BASED`, or `GROUP`. Defaults to `REGULAR`.
     */
    @JvmName("dijdwfhnpucqvhra")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The rule type, either `REGULAR`, `RATE_BASED`, or `GROUP`. Defaults to `REGULAR`.
     */
    @JvmName("rnwywenjrvownufs")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RuleGroupActivatedRuleActionArgs = RuleGroupActivatedRuleActionArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
