@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.inputs

import com.pulumi.aws.wafregional.inputs.WebAclDefaultActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type Specifies how you want AWS WAF Regional to respond to requests that match the settings in a ruleE.g., `ALLOW`, `BLOCK` or `COUNT`
 */
public data class WebAclDefaultActionArgs(
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.wafregional.inputs.WebAclDefaultActionArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.inputs.WebAclDefaultActionArgs =
        com.pulumi.aws.wafregional.inputs.WebAclDefaultActionArgs.builder()
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclDefaultActionArgs].
 */
@PulumiTagMarker
public class WebAclDefaultActionArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value Specifies how you want AWS WAF Regional to respond to requests that match the settings in a ruleE.g., `ALLOW`, `BLOCK` or `COUNT`
     */
    @JvmName("tdkbjtilfeemrbhj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies how you want AWS WAF Regional to respond to requests that match the settings in a ruleE.g., `ALLOW`, `BLOCK` or `COUNT`
     */
    @JvmName("gjxxvnaqbueppske")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): WebAclDefaultActionArgs = WebAclDefaultActionArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
