@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.inputs

import com.pulumi.aws.wafregional.inputs.WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property data When the value of `type` is `HEADER`, enter the name of the header that you want the WAF to search, for example, `User-Agent` or `Referer`. If the value of `type` is any other value, omit `data`.
 * @property type The part of the web request that you want AWS WAF to search for a specified stringE.g., `HEADER` or `METHOD`
 */
public data class WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs(
    public val `data`: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.wafregional.inputs.WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs> {
    override fun toJava():
        com.pulumi.aws.wafregional.inputs.WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs =
        com.pulumi.aws.wafregional.inputs.WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs.builder()
            .`data`(`data`?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs].
 */
@PulumiTagMarker
public class WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgsBuilder internal constructor() {
    private var `data`: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value When the value of `type` is `HEADER`, enter the name of the header that you want the WAF to search, for example, `User-Agent` or `Referer`. If the value of `type` is any other value, omit `data`.
     */
    @JvmName("xermhiwdeeaomdky")
    public suspend fun `data`(`value`: Output<String>) {
        this.`data` = value
    }

    /**
     * @param value The part of the web request that you want AWS WAF to search for a specified stringE.g., `HEADER` or `METHOD`
     */
    @JvmName("awbauafnnpwpqfjd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value When the value of `type` is `HEADER`, enter the name of the header that you want the WAF to search, for example, `User-Agent` or `Referer`. If the value of `type` is any other value, omit `data`.
     */
    @JvmName("udwlucaiaqtdaudd")
    public suspend fun `data`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`data` = mapped
    }

    /**
     * @param value The part of the web request that you want AWS WAF to search for a specified stringE.g., `HEADER` or `METHOD`
     */
    @JvmName("nrnpvqcgvqymqika")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs =
        WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs(
            `data` = `data`,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
