@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.inputs

import com.pulumi.aws.wafregional.inputs.XssMatchSetXssMatchTupleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatch Specifies where in a web request to look for cross-site scripting attacks.
 * @property textTransformation Which text transformation, if any, to perform on the web request before inspecting the request for cross-site scripting attacks.
 */
public data class XssMatchSetXssMatchTupleArgs(
    public val fieldToMatch: Output<XssMatchSetXssMatchTupleFieldToMatchArgs>,
    public val textTransformation: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.wafregional.inputs.XssMatchSetXssMatchTupleArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.inputs.XssMatchSetXssMatchTupleArgs =
        com.pulumi.aws.wafregional.inputs.XssMatchSetXssMatchTupleArgs.builder()
            .fieldToMatch(fieldToMatch.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .textTransformation(textTransformation.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [XssMatchSetXssMatchTupleArgs].
 */
@PulumiTagMarker
public class XssMatchSetXssMatchTupleArgsBuilder internal constructor() {
    private var fieldToMatch: Output<XssMatchSetXssMatchTupleFieldToMatchArgs>? = null

    private var textTransformation: Output<String>? = null

    /**
     * @param value Specifies where in a web request to look for cross-site scripting attacks.
     */
    @JvmName("yqaubokicyqgopwm")
    public suspend fun fieldToMatch(`value`: Output<XssMatchSetXssMatchTupleFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value Which text transformation, if any, to perform on the web request before inspecting the request for cross-site scripting attacks.
     */
    @JvmName("itfhhnedqvtmmoev")
    public suspend fun textTransformation(`value`: Output<String>) {
        this.textTransformation = value
    }

    /**
     * @param value Specifies where in a web request to look for cross-site scripting attacks.
     */
    @JvmName("ydtqpkrfyymxjwmq")
    public suspend fun fieldToMatch(`value`: XssMatchSetXssMatchTupleFieldToMatchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument Specifies where in a web request to look for cross-site scripting attacks.
     */
    @JvmName("pjtgunykhmbmcuao")
    public suspend
    fun fieldToMatch(argument: suspend XssMatchSetXssMatchTupleFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped = XssMatchSetXssMatchTupleFieldToMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value Which text transformation, if any, to perform on the web request before inspecting the request for cross-site scripting attacks.
     */
    @JvmName("knpappppucxceimx")
    public suspend fun textTransformation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformation = mapped
    }

    internal fun build(): XssMatchSetXssMatchTupleArgs = XssMatchSetXssMatchTupleArgs(
        fieldToMatch = fieldToMatch ?: throw PulumiNullFieldException("fieldToMatch"),
        textTransformation = textTransformation ?: throw PulumiNullFieldException("textTransformation"),
    )
}
