@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fieldToMatch Settings for the ByteMatchTuple. FieldToMatch documented below.
 * @property positionalConstraint Within the portion of a web request that you want to search.
 * @property targetString The value that you want AWS WAF to search for. The maximum length of the value is 50 bytes.
 * @property textTransformation The formatting way for web request.
 * FieldToMatch(field_to_match) support following:
 */
public data class ByteMatchSetByteMatchTuple(
    public val fieldToMatch: ByteMatchSetByteMatchTupleFieldToMatch,
    public val positionalConstraint: String,
    public val targetString: String? = null,
    public val textTransformation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafregional.outputs.ByteMatchSetByteMatchTuple):
            ByteMatchSetByteMatchTuple = ByteMatchSetByteMatchTuple(
            fieldToMatch = javaType.fieldToMatch().let({ args0 ->
                com.pulumi.aws.wafregional.kotlin.outputs.ByteMatchSetByteMatchTupleFieldToMatch.Companion.toKotlin(args0)
            }),
            positionalConstraint = javaType.positionalConstraint(),
            targetString = javaType.targetString().map({ args0 -> args0 }).orElse(null),
            textTransformation = javaType.textTransformation(),
        )
    }
}
