@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataId A unique identifier for a predicate in the rule, such as Byte Match Set ID or IPSet ID.
 * @property negated Set this to `false` if you want to allow, block, or count requests
 * based on the settings in the specified `ByteMatchSet`, `IPSet`, `SqlInjectionMatchSet`, `XssMatchSet`, or `SizeConstraintSet`.
 * For example, if an IPSet includes the IP address `192.0.2.44`, AWS WAF will allow or block requests based on that IP address.
 * If set to `true`, AWS WAF will allow, block, or count requests based on all IP addresses _except_ `192.0.2.44`.
 * @property type The type of predicate in a rule. Valid values: `ByteMatch`, `GeoMatch`, `IPMatch`, `RegexMatch`, `SizeConstraint`, `SqlInjectionMatch`, or `XssMatch`.
 */
public data class RateBasedRulePredicate(
    public val dataId: String,
    public val negated: Boolean,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafregional.outputs.RateBasedRulePredicate):
            RateBasedRulePredicate = RateBasedRulePredicate(
            dataId = javaType.dataId(),
            negated = javaType.negated(),
            type = javaType.type(),
        )
    }
}
