@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fieldToMatch The part of a web request that you want to search, such as a specified header or a query string.
 * @property regexPatternSetId The ID of a Regex Pattern Set.
 * @property textTransformation Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
 * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
 * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-TextTransformation)
 * for all supported values.
 */
public data class RegexMatchSetRegexMatchTuple(
    public val fieldToMatch: RegexMatchSetRegexMatchTupleFieldToMatch,
    public val regexPatternSetId: String,
    public val textTransformation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafregional.outputs.RegexMatchSetRegexMatchTuple):
            RegexMatchSetRegexMatchTuple = RegexMatchSetRegexMatchTuple(
            fieldToMatch = javaType.fieldToMatch().let({ args0 ->
                com.pulumi.aws.wafregional.kotlin.outputs.RegexMatchSetRegexMatchTupleFieldToMatch.Companion.toKotlin(args0)
            }),
            regexPatternSetId = javaType.regexPatternSetId(),
            textTransformation = javaType.textTransformation(),
        )
    }
}
