@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property action Specifies the action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule.
 * @property priority Specifies the order in which the rules are evaluated. Rules with a lower value are evaluated before rules with a higher value.
 * @property ruleId The ID of a rule
 * @property type The rule type, either `REGULAR`, `RATE_BASED`, or `GROUP`. Defaults to `REGULAR`.
 */
public data class RuleGroupActivatedRule(
    public val action: RuleGroupActivatedRuleAction,
    public val priority: Int,
    public val ruleId: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafregional.outputs.RuleGroupActivatedRule):
            RuleGroupActivatedRule = RuleGroupActivatedRule(
            action = javaType.action().let({ args0 ->
                com.pulumi.aws.wafregional.kotlin.outputs.RuleGroupActivatedRuleAction.Companion.toKotlin(args0)
            }),
            priority = javaType.priority(),
            ruleId = javaType.ruleId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
