@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fieldToMatch Specifies where in a web request to look for snippets of malicious SQL code.
 * @property textTransformation Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
 * If you specify a transformation, AWS WAF performs the transformation on `field_to_match` before inspecting a request for a match.
 * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
 * See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_regional_SqlInjectionMatchTuple.html#WAF-Type-regional_SqlInjectionMatchTuple-TextTransformation)
 * for all supported values.
 */
public data class SqlInjectionMatchSetSqlInjectionMatchTuple(
    public val fieldToMatch: SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatch,
    public val textTransformation: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.wafregional.outputs.SqlInjectionMatchSetSqlInjectionMatchTuple):
            SqlInjectionMatchSetSqlInjectionMatchTuple = SqlInjectionMatchSetSqlInjectionMatchTuple(
            fieldToMatch = javaType.fieldToMatch().let({ args0 ->
                com.pulumi.aws.wafregional.kotlin.outputs.SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatch.Companion.toKotlin(args0)
            }),
            textTransformation = javaType.textTransformation(),
        )
    }
}
