@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin

import com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupCustomResponseBody
import com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRule
import com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupVisibilityConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupCustomResponseBody.Companion.toKotlin as ruleGroupCustomResponseBodyToKotlin
import com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRule.Companion.toKotlin as ruleGroupRuleToKotlin
import com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupVisibilityConfig.Companion.toKotlin as ruleGroupVisibilityConfigToKotlin

/**
 * Builder for [RuleGroup].
 */
@PulumiTagMarker
public class RuleGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RuleGroupArgs = RuleGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RuleGroupArgsBuilder.() -> Unit) {
        val builder = RuleGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RuleGroup {
        val builtJavaResource = com.pulumi.aws.wafv2.RuleGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RuleGroup(builtJavaResource)
    }
}

public class RuleGroup internal constructor(
    override val javaResource: com.pulumi.aws.wafv2.RuleGroup,
) : KotlinCustomResource(javaResource, RuleGroupMapper) {
    /**
     * The Amazon Resource Name (ARN) of the IP Set that this statement references.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The web ACL capacity units (WCUs) required for this rule group. See [here](https://docs&#46;aws&#46;amazon&#46;com/waf/latest/APIReference/API_CreateRuleGroup&#46;html#API_CreateRuleGroup_RequestSyntax) for general information and [here](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statements-list.html) for capacity specific information.
     */
    public val capacity: Output<Int>
        get() = javaResource.capacity().applyValue({ args0 -> args0 })

    /**
     * Defines custom response bodies that can be referenced by `custom_response` actions. See Custom Response Body below for details.
     */
    public val customResponseBodies: Output<List<RuleGroupCustomResponseBody>>?
        get() = javaResource.customResponseBodies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        ruleGroupCustomResponseBodyToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A friendly description of the rule group.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val lockToken: Output<String>
        get() = javaResource.lockToken().applyValue({ args0 -> args0 })

    /**
     * A friendly name of the rule group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * The rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See Rules below for details.
     */
    public val rules: Output<List<RuleGroupRule>>?
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> ruleGroupRuleToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the region `us-east-1` (N. Virginia) on the AWS provider.
     */
    public val scope: Output<String>
        get() = javaResource.scope().applyValue({ args0 -> args0 })

    /**
     * An array of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection. See Visibility Configuration below for details.
     */
    public val visibilityConfig: Output<RuleGroupVisibilityConfig>
        get() = javaResource.visibilityConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                ruleGroupVisibilityConfigToKotlin(args0)
            })
        })
}

public object RuleGroupMapper : ResourceMapper<RuleGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.wafv2.RuleGroup::class == javaResource::class

    override fun map(javaResource: Resource): RuleGroup = RuleGroup(
        javaResource as
            com.pulumi.aws.wafv2.RuleGroup,
    )
}

/**
 * @see [RuleGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RuleGroup].
 */
public suspend fun ruleGroup(name: String, block: suspend RuleGroupResourceBuilder.() -> Unit):
    RuleGroup {
    val builder = RuleGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RuleGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ruleGroup(name: String): RuleGroup {
    val builder = RuleGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
