@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin

import com.pulumi.aws.wafv2.RuleGroupArgs.builder
import com.pulumi.aws.wafv2.kotlin.inputs.RuleGroupCustomResponseBodyArgs
import com.pulumi.aws.wafv2.kotlin.inputs.RuleGroupCustomResponseBodyArgsBuilder
import com.pulumi.aws.wafv2.kotlin.inputs.RuleGroupRuleArgs
import com.pulumi.aws.wafv2.kotlin.inputs.RuleGroupRuleArgsBuilder
import com.pulumi.aws.wafv2.kotlin.inputs.RuleGroupVisibilityConfigArgs
import com.pulumi.aws.wafv2.kotlin.inputs.RuleGroupVisibilityConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property capacity The web ACL capacity units (WCUs) required for this rule group. See [here](https://docs&#46;aws&#46;amazon&#46;com/waf/latest/APIReference/API_CreateRuleGroup&#46;html#API_CreateRuleGroup_RequestSyntax) for general information and [here](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statements-list.html) for capacity specific information.
 * @property customResponseBodies Defines custom response bodies that can be referenced by `custom_response` actions. See Custom Response Body below for details.
 * @property description A friendly description of the rule group.
 * @property name A friendly name of the rule group.
 * @property namePrefix
 * @property rules The rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See Rules below for details.
 * @property scope Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the region `us-east-1` (N. Virginia) on the AWS provider.
 * @property tags An array of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property visibilityConfig Defines and enables Amazon CloudWatch metrics and web request sample collection. See Visibility Configuration below for details.
 */
public data class RuleGroupArgs(
    public val capacity: Output<Int>? = null,
    public val customResponseBodies: Output<List<RuleGroupCustomResponseBodyArgs>>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val rules: Output<List<RuleGroupRuleArgs>>? = null,
    public val scope: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val visibilityConfig: Output<RuleGroupVisibilityConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.RuleGroupArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.RuleGroupArgs =
        com.pulumi.aws.wafv2.RuleGroupArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .customResponseBodies(
                customResponseBodies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .visibilityConfig(
                visibilityConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupArgs].
 */
@PulumiTagMarker
public class RuleGroupArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var customResponseBodies: Output<List<RuleGroupCustomResponseBodyArgs>>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var rules: Output<List<RuleGroupRuleArgs>>? = null

    private var scope: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var visibilityConfig: Output<RuleGroupVisibilityConfigArgs>? = null

    /**
     * @param value The web ACL capacity units (WCUs) required for this rule group. See [here](https://docs&#46;aws&#46;amazon&#46;com/waf/latest/APIReference/API_CreateRuleGroup&#46;html#API_CreateRuleGroup_RequestSyntax) for general information and [here](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statements-list.html) for capacity specific information.
     */
    @JvmName("wjdrftceaqoldffm")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Defines custom response bodies that can be referenced by `custom_response` actions. See Custom Response Body below for details.
     */
    @JvmName("xusbucnlqnttcpva")
    public suspend fun customResponseBodies(`value`: Output<List<RuleGroupCustomResponseBodyArgs>>) {
        this.customResponseBodies = value
    }

    @JvmName("fkoyqpdbfgdtxmqf")
    public suspend fun customResponseBodies(vararg values: Output<RuleGroupCustomResponseBodyArgs>) {
        this.customResponseBodies = Output.all(values.asList())
    }

    /**
     * @param values Defines custom response bodies that can be referenced by `custom_response` actions. See Custom Response Body below for details.
     */
    @JvmName("wwrqlnwdnlurbqxs")
    public suspend fun customResponseBodies(values: List<Output<RuleGroupCustomResponseBodyArgs>>) {
        this.customResponseBodies = Output.all(values)
    }

    /**
     * @param value A friendly description of the rule group.
     */
    @JvmName("oljmotjgykmvsoee")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A friendly name of the rule group.
     */
    @JvmName("numrsbkoiiuoneej")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("fbnyfdqiqqllfxoj")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See Rules below for details.
     */
    @JvmName("jfhcsewtnftfsjtv")
    public suspend fun rules(`value`: Output<List<RuleGroupRuleArgs>>) {
        this.rules = value
    }

    @JvmName("cgmkhqyecruwuviv")
    public suspend fun rules(vararg values: Output<RuleGroupRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values The rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See Rules below for details.
     */
    @JvmName("mthtoiishkdltlss")
    public suspend fun rules(values: List<Output<RuleGroupRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the region `us-east-1` (N. Virginia) on the AWS provider.
     */
    @JvmName("wpauxpyjklgmwcqd")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value An array of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kqamjhhkwgvtokgt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Defines and enables Amazon CloudWatch metrics and web request sample collection. See Visibility Configuration below for details.
     */
    @JvmName("yvxvymjowyrptthp")
    public suspend fun visibilityConfig(`value`: Output<RuleGroupVisibilityConfigArgs>) {
        this.visibilityConfig = value
    }

    /**
     * @param value The web ACL capacity units (WCUs) required for this rule group. See [here](https://docs&#46;aws&#46;amazon&#46;com/waf/latest/APIReference/API_CreateRuleGroup&#46;html#API_CreateRuleGroup_RequestSyntax) for general information and [here](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statements-list.html) for capacity specific information.
     */
    @JvmName("ycphsasjwmumnqqk")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Defines custom response bodies that can be referenced by `custom_response` actions. See Custom Response Body below for details.
     */
    @JvmName("faccrecvuytgqrww")
    public suspend fun customResponseBodies(`value`: List<RuleGroupCustomResponseBodyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customResponseBodies = mapped
    }

    /**
     * @param argument Defines custom response bodies that can be referenced by `custom_response` actions. See Custom Response Body below for details.
     */
    @JvmName("lvaakxfirvqqdvdt")
    public suspend
    fun customResponseBodies(argument: List<suspend RuleGroupCustomResponseBodyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupCustomResponseBodyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customResponseBodies = mapped
    }

    /**
     * @param argument Defines custom response bodies that can be referenced by `custom_response` actions. See Custom Response Body below for details.
     */
    @JvmName("xhwnxaphuxqdkrad")
    public suspend fun customResponseBodies(
        vararg
        argument: suspend RuleGroupCustomResponseBodyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupCustomResponseBodyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customResponseBodies = mapped
    }

    /**
     * @param argument Defines custom response bodies that can be referenced by `custom_response` actions. See Custom Response Body below for details.
     */
    @JvmName("mioesqpyfjylfudh")
    public suspend
    fun customResponseBodies(argument: suspend RuleGroupCustomResponseBodyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RuleGroupCustomResponseBodyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customResponseBodies = mapped
    }

    /**
     * @param values Defines custom response bodies that can be referenced by `custom_response` actions. See Custom Response Body below for details.
     */
    @JvmName("gtgpdsuvisvsrvom")
    public suspend fun customResponseBodies(vararg values: RuleGroupCustomResponseBodyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customResponseBodies = mapped
    }

    /**
     * @param value A friendly description of the rule group.
     */
    @JvmName("ejnaqmeooafsewxa")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A friendly name of the rule group.
     */
    @JvmName("wmjppaeqncvsubjw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("eqnfdvpofbiathgr")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See Rules below for details.
     */
    @JvmName("dgtwkalmsmlgmqpd")
    public suspend fun rules(`value`: List<RuleGroupRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument The rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See Rules below for details.
     */
    @JvmName("crtbrfliptkyqobo")
    public suspend fun rules(argument: List<suspend RuleGroupRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See Rules below for details.
     */
    @JvmName("afhcaecufrekqkea")
    public suspend fun rules(vararg argument: suspend RuleGroupRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See Rules below for details.
     */
    @JvmName("cdqtcfvxxfnrgane")
    public suspend fun rules(argument: suspend RuleGroupRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuleGroupRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values The rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See Rules below for details.
     */
    @JvmName("ibscajcdawatithd")
    public suspend fun rules(vararg values: RuleGroupRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the region `us-east-1` (N. Virginia) on the AWS provider.
     */
    @JvmName("olukcfivbmhclirp")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value An array of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cdwbfxhmprtdkqwk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values An array of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("madgfhqfslyhlekp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Defines and enables Amazon CloudWatch metrics and web request sample collection. See Visibility Configuration below for details.
     */
    @JvmName("oguverdamieahodg")
    public suspend fun visibilityConfig(`value`: RuleGroupVisibilityConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visibilityConfig = mapped
    }

    /**
     * @param argument Defines and enables Amazon CloudWatch metrics and web request sample collection. See Visibility Configuration below for details.
     */
    @JvmName("pjwsurfxykerqjal")
    public suspend
    fun visibilityConfig(argument: suspend RuleGroupVisibilityConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupVisibilityConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.visibilityConfig = mapped
    }

    internal fun build(): RuleGroupArgs = RuleGroupArgs(
        capacity = capacity,
        customResponseBodies = customResponseBodies,
        description = description,
        name = name,
        namePrefix = namePrefix,
        rules = rules,
        scope = scope,
        tags = tags,
        visibilityConfig = visibilityConfig,
    )
}
