@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin

import com.pulumi.aws.wafv2.WebAclArgs.builder
import com.pulumi.aws.wafv2.kotlin.inputs.WebAclAssociationConfigArgs
import com.pulumi.aws.wafv2.kotlin.inputs.WebAclAssociationConfigArgsBuilder
import com.pulumi.aws.wafv2.kotlin.inputs.WebAclCaptchaConfigArgs
import com.pulumi.aws.wafv2.kotlin.inputs.WebAclCaptchaConfigArgsBuilder
import com.pulumi.aws.wafv2.kotlin.inputs.WebAclCustomResponseBodyArgs
import com.pulumi.aws.wafv2.kotlin.inputs.WebAclCustomResponseBodyArgsBuilder
import com.pulumi.aws.wafv2.kotlin.inputs.WebAclDefaultActionArgs
import com.pulumi.aws.wafv2.kotlin.inputs.WebAclDefaultActionArgsBuilder
import com.pulumi.aws.wafv2.kotlin.inputs.WebAclRuleArgs
import com.pulumi.aws.wafv2.kotlin.inputs.WebAclRuleArgsBuilder
import com.pulumi.aws.wafv2.kotlin.inputs.WebAclVisibilityConfigArgs
import com.pulumi.aws.wafv2.kotlin.inputs.WebAclVisibilityConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property associationConfig Specifies custom configurations for the associations between the web ACL and protected resources. See `association_config` below for details.
 * @property captchaConfig Specifies how AWS WAF should handle CAPTCHA evaluations. See `captcha_config` below for details.
 * @property customResponseBodies Defines custom response bodies that can be referenced by `custom_response` actions. See `custom_response_body` below for details.
 * @property defaultAction Action to perform if none of the `rules` contained in the WebACL match. See `default_action` below for details.
 * @property description Friendly description of the WebACL.
 * @property name Friendly name of the WebACL.
 * @property rules Rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See `rule` below for details.
 * @property scope Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the region `us-east-1` (N. Virginia) on the AWS provider.
 * @property tags Map of key-value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tokenDomains Specifies the domains that AWS WAF should accept in a web request token. This enables the use of tokens across multiple protected websites. When AWS WAF provides a token, it uses the domain of the AWS resource that the web ACL is protecting. If you don't specify a list of token domains, AWS WAF accepts tokens only for the domain of the protected resource. With a token domain list, AWS WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.
 * @property visibilityConfig Defines and enables Amazon CloudWatch metrics and web request sample collection. See `visibility_config` below for details.
 */
public data class WebAclArgs(
    public val associationConfig: Output<WebAclAssociationConfigArgs>? = null,
    public val captchaConfig: Output<WebAclCaptchaConfigArgs>? = null,
    public val customResponseBodies: Output<List<WebAclCustomResponseBodyArgs>>? = null,
    public val defaultAction: Output<WebAclDefaultActionArgs>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val rules: Output<List<WebAclRuleArgs>>? = null,
    public val scope: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tokenDomains: Output<List<String>>? = null,
    public val visibilityConfig: Output<WebAclVisibilityConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.WebAclArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.WebAclArgs = com.pulumi.aws.wafv2.WebAclArgs.builder()
        .associationConfig(associationConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .captchaConfig(captchaConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .customResponseBodies(
            customResponseBodies?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .defaultAction(defaultAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .description(description?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
        .scope(scope?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .tokenDomains(tokenDomains?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .visibilityConfig(
            visibilityConfig?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        ).build()
}

/**
 * Builder for [WebAclArgs].
 */
@PulumiTagMarker
public class WebAclArgsBuilder internal constructor() {
    private var associationConfig: Output<WebAclAssociationConfigArgs>? = null

    private var captchaConfig: Output<WebAclCaptchaConfigArgs>? = null

    private var customResponseBodies: Output<List<WebAclCustomResponseBodyArgs>>? = null

    private var defaultAction: Output<WebAclDefaultActionArgs>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var rules: Output<List<WebAclRuleArgs>>? = null

    private var scope: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tokenDomains: Output<List<String>>? = null

    private var visibilityConfig: Output<WebAclVisibilityConfigArgs>? = null

    /**
     * @param value Specifies custom configurations for the associations between the web ACL and protected resources. See `association_config` below for details.
     */
    @JvmName("qgvcwgmnxmivswea")
    public suspend fun associationConfig(`value`: Output<WebAclAssociationConfigArgs>) {
        this.associationConfig = value
    }

    /**
     * @param value Specifies how AWS WAF should handle CAPTCHA evaluations. See `captcha_config` below for details.
     */
    @JvmName("bknancthwltkxfvx")
    public suspend fun captchaConfig(`value`: Output<WebAclCaptchaConfigArgs>) {
        this.captchaConfig = value
    }

    /**
     * @param value Defines custom response bodies that can be referenced by `custom_response` actions. See `custom_response_body` below for details.
     */
    @JvmName("jivvaitcnllbdknu")
    public suspend fun customResponseBodies(`value`: Output<List<WebAclCustomResponseBodyArgs>>) {
        this.customResponseBodies = value
    }

    @JvmName("ewntamesdamxwamo")
    public suspend fun customResponseBodies(vararg values: Output<WebAclCustomResponseBodyArgs>) {
        this.customResponseBodies = Output.all(values.asList())
    }

    /**
     * @param values Defines custom response bodies that can be referenced by `custom_response` actions. See `custom_response_body` below for details.
     */
    @JvmName("mxhadevwdrbqiggw")
    public suspend fun customResponseBodies(values: List<Output<WebAclCustomResponseBodyArgs>>) {
        this.customResponseBodies = Output.all(values)
    }

    /**
     * @param value Action to perform if none of the `rules` contained in the WebACL match. See `default_action` below for details.
     */
    @JvmName("kmpqdxowadrlvjki")
    public suspend fun defaultAction(`value`: Output<WebAclDefaultActionArgs>) {
        this.defaultAction = value
    }

    /**
     * @param value Friendly description of the WebACL.
     */
    @JvmName("xwjuglwgdulbqhly")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Friendly name of the WebACL.
     */
    @JvmName("waqgxdqmxmlbtihw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See `rule` below for details.
     */
    @JvmName("nwpnkpbiabxwfjus")
    public suspend fun rules(`value`: Output<List<WebAclRuleArgs>>) {
        this.rules = value
    }

    @JvmName("aqpssyfgxewecbnl")
    public suspend fun rules(vararg values: Output<WebAclRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See `rule` below for details.
     */
    @JvmName("xuefuiuavsllxode")
    public suspend fun rules(values: List<Output<WebAclRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the region `us-east-1` (N. Virginia) on the AWS provider.
     */
    @JvmName("lvtrvdubmyxmrnfa")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Map of key-value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hcicrktptoktygws")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the domains that AWS WAF should accept in a web request token. This enables the use of tokens across multiple protected websites. When AWS WAF provides a token, it uses the domain of the AWS resource that the web ACL is protecting. If you don't specify a list of token domains, AWS WAF accepts tokens only for the domain of the protected resource. With a token domain list, AWS WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.
     */
    @JvmName("pslutnvysgdfikgg")
    public suspend fun tokenDomains(`value`: Output<List<String>>) {
        this.tokenDomains = value
    }

    @JvmName("plewglhbacamprpk")
    public suspend fun tokenDomains(vararg values: Output<String>) {
        this.tokenDomains = Output.all(values.asList())
    }

    /**
     * @param values Specifies the domains that AWS WAF should accept in a web request token. This enables the use of tokens across multiple protected websites. When AWS WAF provides a token, it uses the domain of the AWS resource that the web ACL is protecting. If you don't specify a list of token domains, AWS WAF accepts tokens only for the domain of the protected resource. With a token domain list, AWS WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.
     */
    @JvmName("mhadieanfnkovqlp")
    public suspend fun tokenDomains(values: List<Output<String>>) {
        this.tokenDomains = Output.all(values)
    }

    /**
     * @param value Defines and enables Amazon CloudWatch metrics and web request sample collection. See `visibility_config` below for details.
     */
    @JvmName("xfdxagamtbulcvso")
    public suspend fun visibilityConfig(`value`: Output<WebAclVisibilityConfigArgs>) {
        this.visibilityConfig = value
    }

    /**
     * @param value Specifies custom configurations for the associations between the web ACL and protected resources. See `association_config` below for details.
     */
    @JvmName("gsgsjrqbeliwuyvn")
    public suspend fun associationConfig(`value`: WebAclAssociationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associationConfig = mapped
    }

    /**
     * @param argument Specifies custom configurations for the associations between the web ACL and protected resources. See `association_config` below for details.
     */
    @JvmName("htchewhhxnkcplkt")
    public suspend
    fun associationConfig(argument: suspend WebAclAssociationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclAssociationConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.associationConfig = mapped
    }

    /**
     * @param value Specifies how AWS WAF should handle CAPTCHA evaluations. See `captcha_config` below for details.
     */
    @JvmName("kktvikdswoyvtktb")
    public suspend fun captchaConfig(`value`: WebAclCaptchaConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captchaConfig = mapped
    }

    /**
     * @param argument Specifies how AWS WAF should handle CAPTCHA evaluations. See `captcha_config` below for details.
     */
    @JvmName("xkxrsrpegnabweqa")
    public suspend fun captchaConfig(argument: suspend WebAclCaptchaConfigArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclCaptchaConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.captchaConfig = mapped
    }

    /**
     * @param value Defines custom response bodies that can be referenced by `custom_response` actions. See `custom_response_body` below for details.
     */
    @JvmName("hfubaphgueywhnqh")
    public suspend fun customResponseBodies(`value`: List<WebAclCustomResponseBodyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customResponseBodies = mapped
    }

    /**
     * @param argument Defines custom response bodies that can be referenced by `custom_response` actions. See `custom_response_body` below for details.
     */
    @JvmName("drdkxyfnhrvrgktc")
    public suspend
    fun customResponseBodies(argument: List<suspend WebAclCustomResponseBodyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclCustomResponseBodyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customResponseBodies = mapped
    }

    /**
     * @param argument Defines custom response bodies that can be referenced by `custom_response` actions. See `custom_response_body` below for details.
     */
    @JvmName("lvvtlfgecslxdiba")
    public suspend fun customResponseBodies(
        vararg
        argument: suspend WebAclCustomResponseBodyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclCustomResponseBodyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customResponseBodies = mapped
    }

    /**
     * @param argument Defines custom response bodies that can be referenced by `custom_response` actions. See `custom_response_body` below for details.
     */
    @JvmName("dhfkpbjkhlsvepqw")
    public suspend
    fun customResponseBodies(argument: suspend WebAclCustomResponseBodyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebAclCustomResponseBodyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customResponseBodies = mapped
    }

    /**
     * @param values Defines custom response bodies that can be referenced by `custom_response` actions. See `custom_response_body` below for details.
     */
    @JvmName("btkpdbbwatlowvft")
    public suspend fun customResponseBodies(vararg values: WebAclCustomResponseBodyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customResponseBodies = mapped
    }

    /**
     * @param value Action to perform if none of the `rules` contained in the WebACL match. See `default_action` below for details.
     */
    @JvmName("ukcvndwlugexfclr")
    public suspend fun defaultAction(`value`: WebAclDefaultActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param argument Action to perform if none of the `rules` contained in the WebACL match. See `default_action` below for details.
     */
    @JvmName("skjcxbiuipfdswng")
    public suspend fun defaultAction(argument: suspend WebAclDefaultActionArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclDefaultActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultAction = mapped
    }

    /**
     * @param value Friendly description of the WebACL.
     */
    @JvmName("uduogqtisbaeoayl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Friendly name of the WebACL.
     */
    @JvmName("biuffhvxhnuotocc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See `rule` below for details.
     */
    @JvmName("sbqkoyuiipnxyayr")
    public suspend fun rules(`value`: List<WebAclRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See `rule` below for details.
     */
    @JvmName("grbjynfbovbnllqi")
    public suspend fun rules(argument: List<suspend WebAclRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { WebAclRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See `rule` below for details.
     */
    @JvmName("berxxpbjuivabpqk")
    public suspend fun rules(vararg argument: suspend WebAclRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { WebAclRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See `rule` below for details.
     */
    @JvmName("nqpkwyepuhcpphru")
    public suspend fun rules(argument: suspend WebAclRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebAclRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See `rule` below for details.
     */
    @JvmName("vpaicfdhhufbfgno")
    public suspend fun rules(vararg values: WebAclRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the region `us-east-1` (N. Virginia) on the AWS provider.
     */
    @JvmName("xtlcykhhwqkjfwii")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Map of key-value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kowbnlttajqoedpl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of key-value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mrdxwqyutikayswo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the domains that AWS WAF should accept in a web request token. This enables the use of tokens across multiple protected websites. When AWS WAF provides a token, it uses the domain of the AWS resource that the web ACL is protecting. If you don't specify a list of token domains, AWS WAF accepts tokens only for the domain of the protected resource. With a token domain list, AWS WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.
     */
    @JvmName("mdwjelpfhswxthqx")
    public suspend fun tokenDomains(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenDomains = mapped
    }

    /**
     * @param values Specifies the domains that AWS WAF should accept in a web request token. This enables the use of tokens across multiple protected websites. When AWS WAF provides a token, it uses the domain of the AWS resource that the web ACL is protecting. If you don't specify a list of token domains, AWS WAF accepts tokens only for the domain of the protected resource. With a token domain list, AWS WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.
     */
    @JvmName("wyvpldkppushpjbg")
    public suspend fun tokenDomains(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenDomains = mapped
    }

    /**
     * @param value Defines and enables Amazon CloudWatch metrics and web request sample collection. See `visibility_config` below for details.
     */
    @JvmName("fihnmeogqnrgunyk")
    public suspend fun visibilityConfig(`value`: WebAclVisibilityConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visibilityConfig = mapped
    }

    /**
     * @param argument Defines and enables Amazon CloudWatch metrics and web request sample collection. See `visibility_config` below for details.
     */
    @JvmName("qfjfnhxmwbkmlkka")
    public suspend
    fun visibilityConfig(argument: suspend WebAclVisibilityConfigArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclVisibilityConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.visibilityConfig = mapped
    }

    internal fun build(): WebAclArgs = WebAclArgs(
        associationConfig = associationConfig,
        captchaConfig = captchaConfig,
        customResponseBodies = customResponseBodies,
        defaultAction = defaultAction,
        description = description,
        name = name,
        rules = rules,
        scope = scope,
        tags = tags,
        tokenDomains = tokenDomains,
        visibilityConfig = visibilityConfig,
    )
}
