@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebAclAssociation].
 */
@PulumiTagMarker
public class WebAclAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAclAssociationArgs = WebAclAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAclAssociationArgsBuilder.() -> Unit) {
        val builder = WebAclAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebAclAssociation {
        val builtJavaResource = com.pulumi.aws.wafv2.WebAclAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WebAclAssociation(builtJavaResource)
    }
}

/**
 * Creates a WAFv2 Web ACL Association.
 * > **NOTE on associating a WAFv2 Web ACL with a Cloudfront distribution:** Do not use this resource to associate a WAFv2 Web ACL with a Cloudfront Distribution. The [AWS API call backing this resource](https://docs.aws.amazon.com/waf/latest/APIReference/API_AssociateWebACL.html) notes that you should use the `web_acl_id` property on the `cloudfront_distribution` instead.
 * [1]: https://docs.aws.amazon.com/waf/latest/APIReference/API_AssociateWebACL.html
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Deployment;
 * import com.pulumi.aws.apigateway.DeploymentArgs;
 * import com.pulumi.aws.apigateway.Stage;
 * import com.pulumi.aws.apigateway.StageArgs;
 * import com.pulumi.aws.wafv2.WebAcl;
 * import com.pulumi.aws.wafv2.WebAclArgs;
 * import com.pulumi.aws.wafv2.inputs.WebAclDefaultActionArgs;
 * import com.pulumi.aws.wafv2.inputs.WebAclDefaultActionAllowArgs;
 * import com.pulumi.aws.wafv2.inputs.WebAclVisibilityConfigArgs;
 * import com.pulumi.aws.wafv2.WebAclAssociation;
 * import com.pulumi.aws.wafv2.WebAclAssociationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRestApi = new RestApi("exampleRestApi", RestApiArgs.builder()
 *             .body(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("openapi", "3.0.1"),
 *                     jsonProperty("info", jsonObject(
 *                         jsonProperty("title", "example"),
 *                         jsonProperty("version", "1.0")
 *                     )),
 *                     jsonProperty("paths", jsonObject(
 *                         jsonProperty("/path1", jsonObject(
 *                             jsonProperty("get", jsonObject(
 *                                 jsonProperty("x-amazon-apigateway-integration", jsonObject(
 *                                     jsonProperty("httpMethod", "GET"),
 *                                     jsonProperty("payloadFormatVersion", "1.0"),
 *                                     jsonProperty("type", "HTTP_PROXY"),
 *                                     jsonProperty("uri", "https://ip-ranges.amazonaws.com/ip-ranges.json")
 *                                 ))
 *                             ))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *         var exampleDeployment = new Deployment("exampleDeployment", DeploymentArgs.builder()
 *             .restApi(exampleRestApi.id())
 *             .triggers(Map.of("redeployment", exampleRestApi.body().applyValue(body -> serializeJson(
 *                 body)).applyValue(toJSON -> computeSHA1(toJSON))))
 *             .build());
 *         var exampleStage = new Stage("exampleStage", StageArgs.builder()
 *             .deployment(exampleDeployment.id())
 *             .restApi(exampleRestApi.id())
 *             .stageName("example")
 *             .build());
 *         var exampleWebAcl = new WebAcl("exampleWebAcl", WebAclArgs.builder()
 *             .scope("REGIONAL")
 *             .defaultAction(WebAclDefaultActionArgs.builder()
 *                 .allow()
 *                 .build())
 *             .visibilityConfig(WebAclVisibilityConfigArgs.builder()
 *                 .cloudwatchMetricsEnabled(false)
 *                 .metricName("friendly-metric-name")
 *                 .sampledRequestsEnabled(false)
 *                 .build())
 *             .build());
 *         var exampleWebAclAssociation = new WebAclAssociation("exampleWebAclAssociation", WebAclAssociationArgs.builder()
 *             .resourceArn(exampleStage.arn())
 *             .webAclArn(exampleWebAcl.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAFv2 Web ACL Association using `WEB_ACL_ARN,RESOURCE_ARN`. For example:
 * ```sh
 *  $ pulumi import aws:wafv2/webAclAssociation:WebAclAssociation example arn:aws:wafv2:...7ce849ea,arn:aws:apigateway:...ages/name
 * ```
 *
 */
public class WebAclAssociation internal constructor(
    override val javaResource: com.pulumi.aws.wafv2.WebAclAssociation,
) : KotlinCustomResource(javaResource, WebAclAssociationMapper) {
    /**
     * The Amazon Resource Name (ARN) of the resource to associate with the web ACL. This must be an ARN of an Application Load Balancer, an Amazon API Gateway stage, an Amazon Cognito User Pool, an Amazon AppSync GraphQL API, an Amazon App Runner service, or an Amazon Verified Access instance.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the Web ACL that you want to associate with the resource.
     */
    public val webAclArn: Output<String>
        get() = javaResource.webAclArn().applyValue({ args0 -> args0 })
}

public object WebAclAssociationMapper : ResourceMapper<WebAclAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.wafv2.WebAclAssociation::class == javaResource::class

    override fun map(javaResource: Resource): WebAclAssociation = WebAclAssociation(
        javaResource as
            com.pulumi.aws.wafv2.WebAclAssociation,
    )
}

/**
 * @see [WebAclAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAclAssociation].
 */
public suspend fun webAclAssociation(
    name: String,
    block: suspend WebAclAssociationResourceBuilder.() -> Unit,
): WebAclAssociation {
    val builder = WebAclAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAclAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAclAssociation(name: String): WebAclAssociation {
    val builder = WebAclAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
