@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin

import com.pulumi.aws.wafv2.WebAclAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates a WAFv2 Web ACL Association.
 * > **NOTE on associating a WAFv2 Web ACL with a Cloudfront distribution:** Do not use this resource to associate a WAFv2 Web ACL with a Cloudfront Distribution. The [AWS API call backing this resource](https://docs.aws.amazon.com/waf/latest/APIReference/API_AssociateWebACL.html) notes that you should use the `web_acl_id` property on the `cloudfront_distribution` instead.
 * [1]: https://docs.aws.amazon.com/waf/latest/APIReference/API_AssociateWebACL.html
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Deployment;
 * import com.pulumi.aws.apigateway.DeploymentArgs;
 * import com.pulumi.aws.apigateway.Stage;
 * import com.pulumi.aws.apigateway.StageArgs;
 * import com.pulumi.aws.wafv2.WebAcl;
 * import com.pulumi.aws.wafv2.WebAclArgs;
 * import com.pulumi.aws.wafv2.inputs.WebAclDefaultActionArgs;
 * import com.pulumi.aws.wafv2.inputs.WebAclDefaultActionAllowArgs;
 * import com.pulumi.aws.wafv2.inputs.WebAclVisibilityConfigArgs;
 * import com.pulumi.aws.wafv2.WebAclAssociation;
 * import com.pulumi.aws.wafv2.WebAclAssociationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRestApi = new RestApi("exampleRestApi", RestApiArgs.builder()
 *             .body(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("openapi", "3.0.1"),
 *                     jsonProperty("info", jsonObject(
 *                         jsonProperty("title", "example"),
 *                         jsonProperty("version", "1.0")
 *                     )),
 *                     jsonProperty("paths", jsonObject(
 *                         jsonProperty("/path1", jsonObject(
 *                             jsonProperty("get", jsonObject(
 *                                 jsonProperty("x-amazon-apigateway-integration", jsonObject(
 *                                     jsonProperty("httpMethod", "GET"),
 *                                     jsonProperty("payloadFormatVersion", "1.0"),
 *                                     jsonProperty("type", "HTTP_PROXY"),
 *                                     jsonProperty("uri", "https://ip-ranges.amazonaws.com/ip-ranges.json")
 *                                 ))
 *                             ))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *         var exampleDeployment = new Deployment("exampleDeployment", DeploymentArgs.builder()
 *             .restApi(exampleRestApi.id())
 *             .triggers(Map.of("redeployment", exampleRestApi.body().applyValue(body -> serializeJson(
 *                 body)).applyValue(toJSON -> computeSHA1(toJSON))))
 *             .build());
 *         var exampleStage = new Stage("exampleStage", StageArgs.builder()
 *             .deployment(exampleDeployment.id())
 *             .restApi(exampleRestApi.id())
 *             .stageName("example")
 *             .build());
 *         var exampleWebAcl = new WebAcl("exampleWebAcl", WebAclArgs.builder()
 *             .scope("REGIONAL")
 *             .defaultAction(WebAclDefaultActionArgs.builder()
 *                 .allow()
 *                 .build())
 *             .visibilityConfig(WebAclVisibilityConfigArgs.builder()
 *                 .cloudwatchMetricsEnabled(false)
 *                 .metricName("friendly-metric-name")
 *                 .sampledRequestsEnabled(false)
 *                 .build())
 *             .build());
 *         var exampleWebAclAssociation = new WebAclAssociation("exampleWebAclAssociation", WebAclAssociationArgs.builder()
 *             .resourceArn(exampleStage.arn())
 *             .webAclArn(exampleWebAcl.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAFv2 Web ACL Association using `WEB_ACL_ARN,RESOURCE_ARN`. For example:
 * ```sh
 *  $ pulumi import aws:wafv2/webAclAssociation:WebAclAssociation example arn:aws:wafv2:...7ce849ea,arn:aws:apigateway:...ages/name
 * ```
 * @property resourceArn The Amazon Resource Name (ARN) of the resource to associate with the web ACL. This must be an ARN of an Application Load Balancer, an Amazon API Gateway stage, an Amazon Cognito User Pool, an Amazon AppSync GraphQL API, an Amazon App Runner service, or an Amazon Verified Access instance.
 * @property webAclArn The Amazon Resource Name (ARN) of the Web ACL that you want to associate with the resource.
 */
public data class WebAclAssociationArgs(
    public val resourceArn: Output<String>? = null,
    public val webAclArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.WebAclAssociationArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.WebAclAssociationArgs =
        com.pulumi.aws.wafv2.WebAclAssociationArgs.builder()
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 }))
            .webAclArn(webAclArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclAssociationArgs].
 */
@PulumiTagMarker
public class WebAclAssociationArgsBuilder internal constructor() {
    private var resourceArn: Output<String>? = null

    private var webAclArn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the resource to associate with the web ACL. This must be an ARN of an Application Load Balancer, an Amazon API Gateway stage, an Amazon Cognito User Pool, an Amazon AppSync GraphQL API, an Amazon App Runner service, or an Amazon Verified Access instance.
     */
    @JvmName("agfscoqwgqgoykxo")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Web ACL that you want to associate with the resource.
     */
    @JvmName("vkltcmxamkbekrrc")
    public suspend fun webAclArn(`value`: Output<String>) {
        this.webAclArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the resource to associate with the web ACL. This must be an ARN of an Application Load Balancer, an Amazon API Gateway stage, an Amazon Cognito User Pool, an Amazon AppSync GraphQL API, an Amazon App Runner service, or an Amazon Verified Access instance.
     */
    @JvmName("sbxwssjjwlhlhilh")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Web ACL that you want to associate with the resource.
     */
    @JvmName("ojgyyjeeqyufjuoe")
    public suspend fun webAclArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webAclArn = mapped
    }

    internal fun build(): WebAclAssociationArgs = WebAclAssociationArgs(
        resourceArn = resourceArn,
        webAclArn = webAclArn,
    )
}
