@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin

import com.pulumi.aws.wafv2.kotlin.outputs.WebAclLoggingConfigurationLoggingFilter
import com.pulumi.aws.wafv2.kotlin.outputs.WebAclLoggingConfigurationRedactedField
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.wafv2.kotlin.outputs.WebAclLoggingConfigurationLoggingFilter.Companion.toKotlin as webAclLoggingConfigurationLoggingFilterToKotlin
import com.pulumi.aws.wafv2.kotlin.outputs.WebAclLoggingConfigurationRedactedField.Companion.toKotlin as webAclLoggingConfigurationRedactedFieldToKotlin

/**
 * Builder for [WebAclLoggingConfiguration].
 */
@PulumiTagMarker
public class WebAclLoggingConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAclLoggingConfigurationArgs = WebAclLoggingConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAclLoggingConfigurationArgsBuilder.() -> Unit) {
        val builder = WebAclLoggingConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebAclLoggingConfiguration {
        val builtJavaResource = com.pulumi.aws.wafv2.WebAclLoggingConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WebAclLoggingConfiguration(builtJavaResource)
    }
}

/**
 * This resource creates a WAFv2 Web ACL Logging Configuration.
 * !> **WARNING:** When logging from a WAFv2 Web ACL to a CloudWatch Log Group, the WAFv2 service tries to create or update a generic Log Resource Policy named `AWSWAF-LOGS`. However, if there are a large number of Web ACLs or if the account frequently creates and deletes Web ACLs, this policy may exceed the maximum policy size. As a result, this resource type will fail to be created. More details about this issue can be found in this issue. To prevent this issue, you can manage a specific resource policy. Please refer to the example below for managing a CloudWatch Log Group with a managed CloudWatch Log Resource Policy.
 * ## Example Usage
 * ### With Redacted Fields
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafv2.WebAclLoggingConfiguration;
 * import com.pulumi.aws.wafv2.WebAclLoggingConfigurationArgs;
 * import com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationRedactedFieldArgs;
 * import com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationRedactedFieldSingleHeaderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WebAclLoggingConfiguration("example", WebAclLoggingConfigurationArgs.builder()
 *             .logDestinationConfigs(aws_kinesis_firehose_delivery_stream.example().arn())
 *             .resourceArn(aws_wafv2_web_acl.example().arn())
 *             .redactedFields(WebAclLoggingConfigurationRedactedFieldArgs.builder()
 *                 .singleHeader(WebAclLoggingConfigurationRedactedFieldSingleHeaderArgs.builder()
 *                     .name("user-agent")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Logging Filter
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafv2.WebAclLoggingConfiguration;
 * import com.pulumi.aws.wafv2.WebAclLoggingConfigurationArgs;
 * import com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WebAclLoggingConfiguration("example", WebAclLoggingConfigurationArgs.builder()
 *             .logDestinationConfigs(aws_kinesis_firehose_delivery_stream.example().arn())
 *             .resourceArn(aws_wafv2_web_acl.example().arn())
 *             .loggingFilter(WebAclLoggingConfigurationLoggingFilterArgs.builder()
 *                 .defaultBehavior("KEEP")
 *                 .filters(
 *                     WebAclLoggingConfigurationLoggingFilterFilterArgs.builder()
 *                         .behavior("DROP")
 *                         .conditions(
 *                             WebAclLoggingConfigurationLoggingFilterFilterConditionArgs.builder()
 *                                 .actionCondition(WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs.builder()
 *                                     .action("COUNT")
 *                                     .build())
 *                                 .build(),
 *                             WebAclLoggingConfigurationLoggingFilterFilterConditionArgs.builder()
 *                                 .labelNameCondition(WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgs.builder()
 *                                     .labelName("awswaf:111122223333:rulegroup:testRules:LabelNameZ")
 *                                     .build())
 *                                 .build())
 *                         .requirement("MEETS_ALL")
 *                         .build(),
 *                     WebAclLoggingConfigurationLoggingFilterFilterArgs.builder()
 *                         .behavior("KEEP")
 *                         .conditions(WebAclLoggingConfigurationLoggingFilterFilterConditionArgs.builder()
 *                             .actionCondition(WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs.builder()
 *                                 .action("ALLOW")
 *                                 .build())
 *                             .build())
 *                         .requirement("MEETS_ANY")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAFv2 Web ACL Logging Configurations using the ARN of the WAFv2 Web ACL. For example:
 * ```sh
 *  $ pulumi import aws:wafv2/webAclLoggingConfiguration:WebAclLoggingConfiguration example arn:aws:wafv2:us-west-2:123456789012:regional/webacl/test-logs/a1b2c3d4-5678-90ab-cdef
 * ```
 *
 */
public class WebAclLoggingConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.wafv2.WebAclLoggingConfiguration,
) : KotlinCustomResource(javaResource, WebAclLoggingConfigurationMapper) {
    /**
     * Configuration block that allows you to associate Amazon Kinesis Data Firehose, Cloudwatch Log log group, or S3 bucket Amazon Resource Names (ARNs) with the web ACL. **Note:** data firehose, log group, or bucket name **must** be prefixed with `aws-waf-logs-`, e.g. `aws-waf-logs-example-firehose`, `aws-waf-logs-example-log-group`, or `aws-waf-logs-example-bucket`.
     */
    public val logDestinationConfigs: Output<List<String>>
        get() = javaResource.logDestinationConfigs().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Configuration block that specifies which web requests are kept in the logs and which are dropped. It allows filtering based on the rule action and the web request labels applied by matching rules during web ACL evaluation. For more details, refer to the Logging Filter section below.
     */
    public val loggingFilter: Output<WebAclLoggingConfigurationLoggingFilter>?
        get() = javaResource.loggingFilter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    webAclLoggingConfigurationLoggingFilterToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Configuration for parts of the request that you want to keep out of the logs. Up to 100 `redacted_fields` blocks are supported. See Redacted Fields below for more details.
     */
    public val redactedFields: Output<List<WebAclLoggingConfigurationRedactedField>>?
        get() = javaResource.redactedFields().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        webAclLoggingConfigurationRedactedFieldToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the web ACL that you want to associate with `log_destination_configs`.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })
}

public object WebAclLoggingConfigurationMapper : ResourceMapper<WebAclLoggingConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.wafv2.WebAclLoggingConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): WebAclLoggingConfiguration =
        WebAclLoggingConfiguration(javaResource as com.pulumi.aws.wafv2.WebAclLoggingConfiguration)
}

/**
 * @see [WebAclLoggingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAclLoggingConfiguration].
 */
public suspend fun webAclLoggingConfiguration(
    name: String,
    block: suspend WebAclLoggingConfigurationResourceBuilder.() -> Unit,
):
    WebAclLoggingConfiguration {
    val builder = WebAclLoggingConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAclLoggingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAclLoggingConfiguration(name: String): WebAclLoggingConfiguration {
    val builder = WebAclLoggingConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
