@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin

import com.pulumi.aws.wafv2.WebAclLoggingConfigurationArgs.builder
import com.pulumi.aws.wafv2.kotlin.inputs.WebAclLoggingConfigurationLoggingFilterArgs
import com.pulumi.aws.wafv2.kotlin.inputs.WebAclLoggingConfigurationLoggingFilterArgsBuilder
import com.pulumi.aws.wafv2.kotlin.inputs.WebAclLoggingConfigurationRedactedFieldArgs
import com.pulumi.aws.wafv2.kotlin.inputs.WebAclLoggingConfigurationRedactedFieldArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * This resource creates a WAFv2 Web ACL Logging Configuration.
 * !> **WARNING:** When logging from a WAFv2 Web ACL to a CloudWatch Log Group, the WAFv2 service tries to create or update a generic Log Resource Policy named `AWSWAF-LOGS`. However, if there are a large number of Web ACLs or if the account frequently creates and deletes Web ACLs, this policy may exceed the maximum policy size. As a result, this resource type will fail to be created. More details about this issue can be found in this issue. To prevent this issue, you can manage a specific resource policy. Please refer to the example below for managing a CloudWatch Log Group with a managed CloudWatch Log Resource Policy.
 * ## Example Usage
 * ### With Redacted Fields
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafv2.WebAclLoggingConfiguration;
 * import com.pulumi.aws.wafv2.WebAclLoggingConfigurationArgs;
 * import com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationRedactedFieldArgs;
 * import com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationRedactedFieldSingleHeaderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WebAclLoggingConfiguration("example", WebAclLoggingConfigurationArgs.builder()
 *             .logDestinationConfigs(aws_kinesis_firehose_delivery_stream.example().arn())
 *             .resourceArn(aws_wafv2_web_acl.example().arn())
 *             .redactedFields(WebAclLoggingConfigurationRedactedFieldArgs.builder()
 *                 .singleHeader(WebAclLoggingConfigurationRedactedFieldSingleHeaderArgs.builder()
 *                     .name("user-agent")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Logging Filter
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafv2.WebAclLoggingConfiguration;
 * import com.pulumi.aws.wafv2.WebAclLoggingConfigurationArgs;
 * import com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WebAclLoggingConfiguration("example", WebAclLoggingConfigurationArgs.builder()
 *             .logDestinationConfigs(aws_kinesis_firehose_delivery_stream.example().arn())
 *             .resourceArn(aws_wafv2_web_acl.example().arn())
 *             .loggingFilter(WebAclLoggingConfigurationLoggingFilterArgs.builder()
 *                 .defaultBehavior("KEEP")
 *                 .filters(
 *                     WebAclLoggingConfigurationLoggingFilterFilterArgs.builder()
 *                         .behavior("DROP")
 *                         .conditions(
 *                             WebAclLoggingConfigurationLoggingFilterFilterConditionArgs.builder()
 *                                 .actionCondition(WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs.builder()
 *                                     .action("COUNT")
 *                                     .build())
 *                                 .build(),
 *                             WebAclLoggingConfigurationLoggingFilterFilterConditionArgs.builder()
 *                                 .labelNameCondition(WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgs.builder()
 *                                     .labelName("awswaf:111122223333:rulegroup:testRules:LabelNameZ")
 *                                     .build())
 *                                 .build())
 *                         .requirement("MEETS_ALL")
 *                         .build(),
 *                     WebAclLoggingConfigurationLoggingFilterFilterArgs.builder()
 *                         .behavior("KEEP")
 *                         .conditions(WebAclLoggingConfigurationLoggingFilterFilterConditionArgs.builder()
 *                             .actionCondition(WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs.builder()
 *                                 .action("ALLOW")
 *                                 .build())
 *                             .build())
 *                         .requirement("MEETS_ANY")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAFv2 Web ACL Logging Configurations using the ARN of the WAFv2 Web ACL. For example:
 * ```sh
 *  $ pulumi import aws:wafv2/webAclLoggingConfiguration:WebAclLoggingConfiguration example arn:aws:wafv2:us-west-2:123456789012:regional/webacl/test-logs/a1b2c3d4-5678-90ab-cdef
 * ```
 * @property logDestinationConfigs Configuration block that allows you to associate Amazon Kinesis Data Firehose, Cloudwatch Log log group, or S3 bucket Amazon Resource Names (ARNs) with the web ACL. **Note:** data firehose, log group, or bucket name **must** be prefixed with `aws-waf-logs-`, e.g. `aws-waf-logs-example-firehose`, `aws-waf-logs-example-log-group`, or `aws-waf-logs-example-bucket`.
 * @property loggingFilter Configuration block that specifies which web requests are kept in the logs and which are dropped. It allows filtering based on the rule action and the web request labels applied by matching rules during web ACL evaluation. For more details, refer to the Logging Filter section below.
 * @property redactedFields Configuration for parts of the request that you want to keep out of the logs. Up to 100 `redacted_fields` blocks are supported. See Redacted Fields below for more details.
 * @property resourceArn Amazon Resource Name (ARN) of the web ACL that you want to associate with `log_destination_configs`.
 */
public data class WebAclLoggingConfigurationArgs(
    public val logDestinationConfigs: Output<List<String>>? = null,
    public val loggingFilter: Output<WebAclLoggingConfigurationLoggingFilterArgs>? = null,
    public val redactedFields: Output<List<WebAclLoggingConfigurationRedactedFieldArgs>>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.WebAclLoggingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.WebAclLoggingConfigurationArgs =
        com.pulumi.aws.wafv2.WebAclLoggingConfigurationArgs.builder()
            .logDestinationConfigs(logDestinationConfigs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .loggingFilter(loggingFilter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .redactedFields(
                redactedFields?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclLoggingConfigurationArgs].
 */
@PulumiTagMarker
public class WebAclLoggingConfigurationArgsBuilder internal constructor() {
    private var logDestinationConfigs: Output<List<String>>? = null

    private var loggingFilter: Output<WebAclLoggingConfigurationLoggingFilterArgs>? = null

    private var redactedFields: Output<List<WebAclLoggingConfigurationRedactedFieldArgs>>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value Configuration block that allows you to associate Amazon Kinesis Data Firehose, Cloudwatch Log log group, or S3 bucket Amazon Resource Names (ARNs) with the web ACL. **Note:** data firehose, log group, or bucket name **must** be prefixed with `aws-waf-logs-`, e.g. `aws-waf-logs-example-firehose`, `aws-waf-logs-example-log-group`, or `aws-waf-logs-example-bucket`.
     */
    @JvmName("mdbhnjobrcmslngy")
    public suspend fun logDestinationConfigs(`value`: Output<List<String>>) {
        this.logDestinationConfigs = value
    }

    @JvmName("vfdebqgpvqlcthfe")
    public suspend fun logDestinationConfigs(vararg values: Output<String>) {
        this.logDestinationConfigs = Output.all(values.asList())
    }

    /**
     * @param values Configuration block that allows you to associate Amazon Kinesis Data Firehose, Cloudwatch Log log group, or S3 bucket Amazon Resource Names (ARNs) with the web ACL. **Note:** data firehose, log group, or bucket name **must** be prefixed with `aws-waf-logs-`, e.g. `aws-waf-logs-example-firehose`, `aws-waf-logs-example-log-group`, or `aws-waf-logs-example-bucket`.
     */
    @JvmName("jkntkjgehepthmwy")
    public suspend fun logDestinationConfigs(values: List<Output<String>>) {
        this.logDestinationConfigs = Output.all(values)
    }

    /**
     * @param value Configuration block that specifies which web requests are kept in the logs and which are dropped. It allows filtering based on the rule action and the web request labels applied by matching rules during web ACL evaluation. For more details, refer to the Logging Filter section below.
     */
    @JvmName("yittldcbkadhqmhw")
    public suspend fun loggingFilter(`value`: Output<WebAclLoggingConfigurationLoggingFilterArgs>) {
        this.loggingFilter = value
    }

    /**
     * @param value Configuration for parts of the request that you want to keep out of the logs. Up to 100 `redacted_fields` blocks are supported. See Redacted Fields below for more details.
     */
    @JvmName("eaqaluvorjtvknpe")
    public suspend
    fun redactedFields(`value`: Output<List<WebAclLoggingConfigurationRedactedFieldArgs>>) {
        this.redactedFields = value
    }

    @JvmName("jsdwppxbhluamdcn")
    public suspend fun redactedFields(
        vararg
        values: Output<WebAclLoggingConfigurationRedactedFieldArgs>,
    ) {
        this.redactedFields = Output.all(values.asList())
    }

    /**
     * @param values Configuration for parts of the request that you want to keep out of the logs. Up to 100 `redacted_fields` blocks are supported. See Redacted Fields below for more details.
     */
    @JvmName("jrmttdtqmqrwpcxj")
    public suspend
    fun redactedFields(values: List<Output<WebAclLoggingConfigurationRedactedFieldArgs>>) {
        this.redactedFields = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) of the web ACL that you want to associate with `log_destination_configs`.
     */
    @JvmName("hpusgbosxbpckhkf")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value Configuration block that allows you to associate Amazon Kinesis Data Firehose, Cloudwatch Log log group, or S3 bucket Amazon Resource Names (ARNs) with the web ACL. **Note:** data firehose, log group, or bucket name **must** be prefixed with `aws-waf-logs-`, e.g. `aws-waf-logs-example-firehose`, `aws-waf-logs-example-log-group`, or `aws-waf-logs-example-bucket`.
     */
    @JvmName("rfiwuwrwgvtvbjma")
    public suspend fun logDestinationConfigs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logDestinationConfigs = mapped
    }

    /**
     * @param values Configuration block that allows you to associate Amazon Kinesis Data Firehose, Cloudwatch Log log group, or S3 bucket Amazon Resource Names (ARNs) with the web ACL. **Note:** data firehose, log group, or bucket name **must** be prefixed with `aws-waf-logs-`, e.g. `aws-waf-logs-example-firehose`, `aws-waf-logs-example-log-group`, or `aws-waf-logs-example-bucket`.
     */
    @JvmName("htmqgoigjihaxbju")
    public suspend fun logDestinationConfigs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logDestinationConfigs = mapped
    }

    /**
     * @param value Configuration block that specifies which web requests are kept in the logs and which are dropped. It allows filtering based on the rule action and the web request labels applied by matching rules during web ACL evaluation. For more details, refer to the Logging Filter section below.
     */
    @JvmName("ebqkclrmmivhpiei")
    public suspend fun loggingFilter(`value`: WebAclLoggingConfigurationLoggingFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingFilter = mapped
    }

    /**
     * @param argument Configuration block that specifies which web requests are kept in the logs and which are dropped. It allows filtering based on the rule action and the web request labels applied by matching rules during web ACL evaluation. For more details, refer to the Logging Filter section below.
     */
    @JvmName("ugjrswwvbglqmqna")
    public suspend
    fun loggingFilter(argument: suspend WebAclLoggingConfigurationLoggingFilterArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclLoggingConfigurationLoggingFilterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.loggingFilter = mapped
    }

    /**
     * @param value Configuration for parts of the request that you want to keep out of the logs. Up to 100 `redacted_fields` blocks are supported. See Redacted Fields below for more details.
     */
    @JvmName("tnuojwdnhiksfmhd")
    public suspend fun redactedFields(`value`: List<WebAclLoggingConfigurationRedactedFieldArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redactedFields = mapped
    }

    /**
     * @param argument Configuration for parts of the request that you want to keep out of the logs. Up to 100 `redacted_fields` blocks are supported. See Redacted Fields below for more details.
     */
    @JvmName("ngfrtqjfabytxnvx")
    public suspend
    fun redactedFields(argument: List<suspend WebAclLoggingConfigurationRedactedFieldArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclLoggingConfigurationRedactedFieldArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.redactedFields = mapped
    }

    /**
     * @param argument Configuration for parts of the request that you want to keep out of the logs. Up to 100 `redacted_fields` blocks are supported. See Redacted Fields below for more details.
     */
    @JvmName("udfhabybwgbhscvc")
    public suspend fun redactedFields(
        vararg
        argument: suspend WebAclLoggingConfigurationRedactedFieldArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebAclLoggingConfigurationRedactedFieldArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.redactedFields = mapped
    }

    /**
     * @param argument Configuration for parts of the request that you want to keep out of the logs. Up to 100 `redacted_fields` blocks are supported. See Redacted Fields below for more details.
     */
    @JvmName("qruubglrbcbctmaj")
    public suspend
    fun redactedFields(argument: suspend WebAclLoggingConfigurationRedactedFieldArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebAclLoggingConfigurationRedactedFieldArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.redactedFields = mapped
    }

    /**
     * @param values Configuration for parts of the request that you want to keep out of the logs. Up to 100 `redacted_fields` blocks are supported. See Redacted Fields below for more details.
     */
    @JvmName("rmgudytajrgssbtj")
    public suspend fun redactedFields(vararg values: WebAclLoggingConfigurationRedactedFieldArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redactedFields = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the web ACL that you want to associate with `log_destination_configs`.
     */
    @JvmName("scqgtaxvlxdkdrlt")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): WebAclLoggingConfigurationArgs = WebAclLoggingConfigurationArgs(
        logDestinationConfigs = logDestinationConfigs,
        loggingFilter = loggingFilter,
        redactedFields = redactedFields,
        resourceArn = resourceArn,
    )
}
