@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionAllowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customRequestHandling Defines custom handling for the web request. See Custom Request Handling below for details.
 */
public data class RuleGroupRuleActionAllowArgs(
    public val customRequestHandling: Output<RuleGroupRuleActionAllowCustomRequestHandlingArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionAllowArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionAllowArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionAllowArgs.builder()
            .customRequestHandling(
                customRequestHandling?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleActionAllowArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleActionAllowArgsBuilder internal constructor() {
    private var customRequestHandling: Output<RuleGroupRuleActionAllowCustomRequestHandlingArgs>? =
        null

    /**
     * @param value Defines custom handling for the web request. See Custom Request Handling below for details.
     */
    @JvmName("odumpvosdrlhslwi")
    public suspend
    fun customRequestHandling(`value`: Output<RuleGroupRuleActionAllowCustomRequestHandlingArgs>) {
        this.customRequestHandling = value
    }

    /**
     * @param value Defines custom handling for the web request. See Custom Request Handling below for details.
     */
    @JvmName("ympgrqrfsopdjenc")
    public suspend
    fun customRequestHandling(`value`: RuleGroupRuleActionAllowCustomRequestHandlingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRequestHandling = mapped
    }

    /**
     * @param argument Defines custom handling for the web request. See Custom Request Handling below for details.
     */
    @JvmName("nkmwncyerivsxfhd")
    public suspend
    fun customRequestHandling(argument: suspend RuleGroupRuleActionAllowCustomRequestHandlingArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleActionAllowCustomRequestHandlingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customRequestHandling = mapped
    }

    internal fun build(): RuleGroupRuleActionAllowArgs = RuleGroupRuleActionAllowArgs(
        customRequestHandling = customRequestHandling,
    )
}
