@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionAllowCustomRequestHandlingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property insertHeaders The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
 */
public data class RuleGroupRuleActionAllowCustomRequestHandlingArgs(
    public val insertHeaders:
    Output<List<RuleGroupRuleActionAllowCustomRequestHandlingInsertHeaderArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionAllowCustomRequestHandlingArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionAllowCustomRequestHandlingArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionAllowCustomRequestHandlingArgs.builder()
            .insertHeaders(
                insertHeaders.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleActionAllowCustomRequestHandlingArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleActionAllowCustomRequestHandlingArgsBuilder internal constructor() {
    private var insertHeaders:
        Output<List<RuleGroupRuleActionAllowCustomRequestHandlingInsertHeaderArgs>>? = null

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("qexvrybhxwwexuch")
    public suspend
    fun insertHeaders(`value`: Output<List<RuleGroupRuleActionAllowCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = value
    }

    @JvmName("vfyhwamqcgsgwteq")
    public suspend fun insertHeaders(
        vararg
        values: Output<RuleGroupRuleActionAllowCustomRequestHandlingInsertHeaderArgs>,
    ) {
        this.insertHeaders = Output.all(values.asList())
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("iiypqbeidfihsptf")
    public suspend
    fun insertHeaders(values: List<Output<RuleGroupRuleActionAllowCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = Output.all(values)
    }

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("jatswayohsdtascu")
    public suspend
    fun insertHeaders(`value`: List<RuleGroupRuleActionAllowCustomRequestHandlingInsertHeaderArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("jumgviyxqhlxtmjm")
    public suspend
    fun insertHeaders(argument: List<suspend RuleGroupRuleActionAllowCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleActionAllowCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("hdgunxmjvykiusqk")
    public suspend fun insertHeaders(
        vararg
        argument: suspend RuleGroupRuleActionAllowCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleActionAllowCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("yjswqsxdbpvhdyad")
    public suspend
    fun insertHeaders(argument: suspend RuleGroupRuleActionAllowCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleActionAllowCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("kteunxxnlohiajbj")
    public suspend fun insertHeaders(
        vararg
        values: RuleGroupRuleActionAllowCustomRequestHandlingInsertHeaderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    internal fun build(): RuleGroupRuleActionAllowCustomRequestHandlingArgs =
        RuleGroupRuleActionAllowCustomRequestHandlingArgs(
            insertHeaders = insertHeaders ?: throw PulumiNullFieldException("insertHeaders"),
        )
}
