@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionBlockCustomResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customResponseBodyKey References the response body that you want AWS WAF to return to the web request client. This must reference a `key` defined in a `custom_response_body` block of this resource.
 * @property responseCode The HTTP status code to return to the client.
 * @property responseHeaders The `response_header` blocks used to define the HTTP response headers added to the response. See Custom HTTP Header below for details.
 */
public data class RuleGroupRuleActionBlockCustomResponseArgs(
    public val customResponseBodyKey: Output<String>? = null,
    public val responseCode: Output<Int>,
    public val responseHeaders:
    Output<List<RuleGroupRuleActionBlockCustomResponseResponseHeaderArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionBlockCustomResponseArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionBlockCustomResponseArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionBlockCustomResponseArgs.builder()
            .customResponseBodyKey(customResponseBodyKey?.applyValue({ args0 -> args0 }))
            .responseCode(responseCode.applyValue({ args0 -> args0 }))
            .responseHeaders(
                responseHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleActionBlockCustomResponseArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleActionBlockCustomResponseArgsBuilder internal constructor() {
    private var customResponseBodyKey: Output<String>? = null

    private var responseCode: Output<Int>? = null

    private var responseHeaders:
        Output<List<RuleGroupRuleActionBlockCustomResponseResponseHeaderArgs>>? = null

    /**
     * @param value References the response body that you want AWS WAF to return to the web request client. This must reference a `key` defined in a `custom_response_body` block of this resource.
     */
    @JvmName("yojpmdgewholfltg")
    public suspend fun customResponseBodyKey(`value`: Output<String>) {
        this.customResponseBodyKey = value
    }

    /**
     * @param value The HTTP status code to return to the client.
     */
    @JvmName("kdoylnfnblotouyj")
    public suspend fun responseCode(`value`: Output<Int>) {
        this.responseCode = value
    }

    /**
     * @param value The `response_header` blocks used to define the HTTP response headers added to the response. See Custom HTTP Header below for details.
     */
    @JvmName("igmvsbixdsggqmdb")
    public suspend
    fun responseHeaders(`value`: Output<List<RuleGroupRuleActionBlockCustomResponseResponseHeaderArgs>>) {
        this.responseHeaders = value
    }

    @JvmName("wbigvmdromikkgjy")
    public suspend fun responseHeaders(
        vararg
        values: Output<RuleGroupRuleActionBlockCustomResponseResponseHeaderArgs>,
    ) {
        this.responseHeaders = Output.all(values.asList())
    }

    /**
     * @param values The `response_header` blocks used to define the HTTP response headers added to the response. See Custom HTTP Header below for details.
     */
    @JvmName("qwlalcxskikrptjt")
    public suspend
    fun responseHeaders(values: List<Output<RuleGroupRuleActionBlockCustomResponseResponseHeaderArgs>>) {
        this.responseHeaders = Output.all(values)
    }

    /**
     * @param value References the response body that you want AWS WAF to return to the web request client. This must reference a `key` defined in a `custom_response_body` block of this resource.
     */
    @JvmName("ektrtleabeapaxxg")
    public suspend fun customResponseBodyKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customResponseBodyKey = mapped
    }

    /**
     * @param value The HTTP status code to return to the client.
     */
    @JvmName("hhujewbyohtfwtoc")
    public suspend fun responseCode(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseCode = mapped
    }

    /**
     * @param value The `response_header` blocks used to define the HTTP response headers added to the response. See Custom HTTP Header below for details.
     */
    @JvmName("hwvdftqbeqfjcerk")
    public suspend
    fun responseHeaders(`value`: List<RuleGroupRuleActionBlockCustomResponseResponseHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseHeaders = mapped
    }

    /**
     * @param argument The `response_header` blocks used to define the HTTP response headers added to the response. See Custom HTTP Header below for details.
     */
    @JvmName("depsmknvrarwubmw")
    public suspend
    fun responseHeaders(argument: List<suspend RuleGroupRuleActionBlockCustomResponseResponseHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleActionBlockCustomResponseResponseHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.responseHeaders = mapped
    }

    /**
     * @param argument The `response_header` blocks used to define the HTTP response headers added to the response. See Custom HTTP Header below for details.
     */
    @JvmName("tjmfmiirmurhdjlg")
    public suspend fun responseHeaders(
        vararg
        argument: suspend RuleGroupRuleActionBlockCustomResponseResponseHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleActionBlockCustomResponseResponseHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.responseHeaders = mapped
    }

    /**
     * @param argument The `response_header` blocks used to define the HTTP response headers added to the response. See Custom HTTP Header below for details.
     */
    @JvmName("sggssbrojtrbxiev")
    public suspend
    fun responseHeaders(argument: suspend RuleGroupRuleActionBlockCustomResponseResponseHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleActionBlockCustomResponseResponseHeaderArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.responseHeaders = mapped
    }

    /**
     * @param values The `response_header` blocks used to define the HTTP response headers added to the response. See Custom HTTP Header below for details.
     */
    @JvmName("waoborjawyekipho")
    public suspend fun responseHeaders(
        vararg
        values: RuleGroupRuleActionBlockCustomResponseResponseHeaderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseHeaders = mapped
    }

    internal fun build(): RuleGroupRuleActionBlockCustomResponseArgs =
        RuleGroupRuleActionBlockCustomResponseArgs(
            customResponseBodyKey = customResponseBodyKey,
            responseCode = responseCode ?: throw PulumiNullFieldException("responseCode"),
            responseHeaders = responseHeaders,
        )
}
