@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionCaptchaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customRequestHandling Defines custom handling for the web request. See Custom Request Handling below for details.
 */
public data class RuleGroupRuleActionCaptchaArgs(
    public val customRequestHandling: Output<RuleGroupRuleActionCaptchaCustomRequestHandlingArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionCaptchaArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionCaptchaArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionCaptchaArgs.builder()
            .customRequestHandling(
                customRequestHandling?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleActionCaptchaArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleActionCaptchaArgsBuilder internal constructor() {
    private var customRequestHandling: Output<RuleGroupRuleActionCaptchaCustomRequestHandlingArgs>? =
        null

    /**
     * @param value Defines custom handling for the web request. See Custom Request Handling below for details.
     */
    @JvmName("phfkjjbfiijkhclk")
    public suspend
    fun customRequestHandling(`value`: Output<RuleGroupRuleActionCaptchaCustomRequestHandlingArgs>) {
        this.customRequestHandling = value
    }

    /**
     * @param value Defines custom handling for the web request. See Custom Request Handling below for details.
     */
    @JvmName("jqvetlsrkqpobrki")
    public suspend
    fun customRequestHandling(`value`: RuleGroupRuleActionCaptchaCustomRequestHandlingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRequestHandling = mapped
    }

    /**
     * @param argument Defines custom handling for the web request. See Custom Request Handling below for details.
     */
    @JvmName("avfmdihpjbvebvbf")
    public suspend
    fun customRequestHandling(argument: suspend RuleGroupRuleActionCaptchaCustomRequestHandlingArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleActionCaptchaCustomRequestHandlingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customRequestHandling = mapped
    }

    internal fun build(): RuleGroupRuleActionCaptchaArgs = RuleGroupRuleActionCaptchaArgs(
        customRequestHandling = customRequestHandling,
    )
}
