@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionCountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customRequestHandling Defines custom handling for the web request. See Custom Request Handling below for details.
 */
public data class RuleGroupRuleActionCountArgs(
    public val customRequestHandling: Output<RuleGroupRuleActionCountCustomRequestHandlingArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionCountArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionCountArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionCountArgs.builder()
            .customRequestHandling(
                customRequestHandling?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleActionCountArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleActionCountArgsBuilder internal constructor() {
    private var customRequestHandling: Output<RuleGroupRuleActionCountCustomRequestHandlingArgs>? =
        null

    /**
     * @param value Defines custom handling for the web request. See Custom Request Handling below for details.
     */
    @JvmName("gorxtcsgoevowkjo")
    public suspend
    fun customRequestHandling(`value`: Output<RuleGroupRuleActionCountCustomRequestHandlingArgs>) {
        this.customRequestHandling = value
    }

    /**
     * @param value Defines custom handling for the web request. See Custom Request Handling below for details.
     */
    @JvmName("hanqihdeqawugugi")
    public suspend
    fun customRequestHandling(`value`: RuleGroupRuleActionCountCustomRequestHandlingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRequestHandling = mapped
    }

    /**
     * @param argument Defines custom handling for the web request. See Custom Request Handling below for details.
     */
    @JvmName("gwkpgrskblqeiswh")
    public suspend
    fun customRequestHandling(argument: suspend RuleGroupRuleActionCountCustomRequestHandlingArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleActionCountCustomRequestHandlingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customRequestHandling = mapped
    }

    internal fun build(): RuleGroupRuleActionCountArgs = RuleGroupRuleActionCountArgs(
        customRequestHandling = customRequestHandling,
    )
}
