@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionCountCustomRequestHandlingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property insertHeaders The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
 */
public data class RuleGroupRuleActionCountCustomRequestHandlingArgs(
    public val insertHeaders:
    Output<List<RuleGroupRuleActionCountCustomRequestHandlingInsertHeaderArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionCountCustomRequestHandlingArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionCountCustomRequestHandlingArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionCountCustomRequestHandlingArgs.builder()
            .insertHeaders(
                insertHeaders.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleActionCountCustomRequestHandlingArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleActionCountCustomRequestHandlingArgsBuilder internal constructor() {
    private var insertHeaders:
        Output<List<RuleGroupRuleActionCountCustomRequestHandlingInsertHeaderArgs>>? = null

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("drccwcsgwemfmytl")
    public suspend
    fun insertHeaders(`value`: Output<List<RuleGroupRuleActionCountCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = value
    }

    @JvmName("vmmjkicbhavwwvfu")
    public suspend fun insertHeaders(
        vararg
        values: Output<RuleGroupRuleActionCountCustomRequestHandlingInsertHeaderArgs>,
    ) {
        this.insertHeaders = Output.all(values.asList())
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("gujrfgotexodmodi")
    public suspend
    fun insertHeaders(values: List<Output<RuleGroupRuleActionCountCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = Output.all(values)
    }

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("ufvqejpqphyswtjj")
    public suspend
    fun insertHeaders(`value`: List<RuleGroupRuleActionCountCustomRequestHandlingInsertHeaderArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("mtipfalncvomvmow")
    public suspend
    fun insertHeaders(argument: List<suspend RuleGroupRuleActionCountCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleActionCountCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("yuubrcgywlpqnadg")
    public suspend fun insertHeaders(
        vararg
        argument: suspend RuleGroupRuleActionCountCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleActionCountCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("tftvxilyypxcpclq")
    public suspend
    fun insertHeaders(argument: suspend RuleGroupRuleActionCountCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleActionCountCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("euolxrcgtnetdeap")
    public suspend fun insertHeaders(
        vararg
        values: RuleGroupRuleActionCountCustomRequestHandlingInsertHeaderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    internal fun build(): RuleGroupRuleActionCountCustomRequestHandlingArgs =
        RuleGroupRuleActionCountCustomRequestHandlingArgs(
            insertHeaders = insertHeaders ?: throw PulumiNullFieldException("insertHeaders"),
        )
}
