@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property action The action that AWS WAF should take on a web request when it matches the rule's statement. Settings at the `aws.wafv2.WebAcl` level can override the rule action setting. See Action below for details.
 * @property captchaConfig Specifies how AWS WAF should handle CAPTCHA evaluations. See Captcha Configuration below for details.
 * @property name A friendly name of the rule.
 * @property priority If you define more than one Rule in a WebACL, AWS WAF evaluates each request against the `rules` in order based on the value of `priority`. AWS WAF processes rules with lower priority first.
 * @property ruleLabels Labels to apply to web requests that match the rule match statement. See Rule Label below for details.
 * @property statement The AWS WAF processing statement for the rule, for example `byte_match_statement` or `geo_match_statement`. See Statement below for details.
 * @property visibilityConfig Defines and enables Amazon CloudWatch metrics and web request sample collection. See Visibility Configuration below for details.
 */
public data class RuleGroupRuleArgs(
    public val action: Output<RuleGroupRuleActionArgs>,
    public val captchaConfig: Output<RuleGroupRuleCaptchaConfigArgs>? = null,
    public val name: Output<String>,
    public val priority: Output<Int>,
    public val ruleLabels: Output<List<RuleGroupRuleRuleLabelArgs>>? = null,
    public val statement: Output<RuleGroupRuleStatementArgs>,
    public val visibilityConfig: Output<RuleGroupRuleVisibilityConfigArgs>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleArgs.builder()
            .action(action.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .captchaConfig(captchaConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .priority(priority.applyValue({ args0 -> args0 }))
            .ruleLabels(
                ruleLabels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .statement(statement.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .visibilityConfig(
                visibilityConfig.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleArgsBuilder internal constructor() {
    private var action: Output<RuleGroupRuleActionArgs>? = null

    private var captchaConfig: Output<RuleGroupRuleCaptchaConfigArgs>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var ruleLabels: Output<List<RuleGroupRuleRuleLabelArgs>>? = null

    private var statement: Output<RuleGroupRuleStatementArgs>? = null

    private var visibilityConfig: Output<RuleGroupRuleVisibilityConfigArgs>? = null

    /**
     * @param value The action that AWS WAF should take on a web request when it matches the rule's statement. Settings at the `aws.wafv2.WebAcl` level can override the rule action setting. See Action below for details.
     */
    @JvmName("mjairwtxdubhsctd")
    public suspend fun action(`value`: Output<RuleGroupRuleActionArgs>) {
        this.action = value
    }

    /**
     * @param value Specifies how AWS WAF should handle CAPTCHA evaluations. See Captcha Configuration below for details.
     */
    @JvmName("lrxrvgtnisxqvipu")
    public suspend fun captchaConfig(`value`: Output<RuleGroupRuleCaptchaConfigArgs>) {
        this.captchaConfig = value
    }

    /**
     * @param value A friendly name of the rule.
     */
    @JvmName("swoufxrxlkywgxhs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value If you define more than one Rule in a WebACL, AWS WAF evaluates each request against the `rules` in order based on the value of `priority`. AWS WAF processes rules with lower priority first.
     */
    @JvmName("fbxpfxripcygylym")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Labels to apply to web requests that match the rule match statement. See Rule Label below for details.
     */
    @JvmName("yyxsnfxtiliyoksf")
    public suspend fun ruleLabels(`value`: Output<List<RuleGroupRuleRuleLabelArgs>>) {
        this.ruleLabels = value
    }

    @JvmName("ijccqmjddkhhsrpp")
    public suspend fun ruleLabels(vararg values: Output<RuleGroupRuleRuleLabelArgs>) {
        this.ruleLabels = Output.all(values.asList())
    }

    /**
     * @param values Labels to apply to web requests that match the rule match statement. See Rule Label below for details.
     */
    @JvmName("ualroxkjiohrmase")
    public suspend fun ruleLabels(values: List<Output<RuleGroupRuleRuleLabelArgs>>) {
        this.ruleLabels = Output.all(values)
    }

    /**
     * @param value The AWS WAF processing statement for the rule, for example `byte_match_statement` or `geo_match_statement`. See Statement below for details.
     */
    @JvmName("knkefrvwswknhghi")
    public suspend fun statement(`value`: Output<RuleGroupRuleStatementArgs>) {
        this.statement = value
    }

    /**
     * @param value Defines and enables Amazon CloudWatch metrics and web request sample collection. See Visibility Configuration below for details.
     */
    @JvmName("smqmlljqysyqnuet")
    public suspend fun visibilityConfig(`value`: Output<RuleGroupRuleVisibilityConfigArgs>) {
        this.visibilityConfig = value
    }

    /**
     * @param value The action that AWS WAF should take on a web request when it matches the rule's statement. Settings at the `aws.wafv2.WebAcl` level can override the rule action setting. See Action below for details.
     */
    @JvmName("rpeauduionrubgbd")
    public suspend fun action(`value`: RuleGroupRuleActionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument The action that AWS WAF should take on a web request when it matches the rule's statement. Settings at the `aws.wafv2.WebAcl` level can override the rule action setting. See Action below for details.
     */
    @JvmName("eobxocdbprfoassr")
    public suspend fun action(argument: suspend RuleGroupRuleActionArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Specifies how AWS WAF should handle CAPTCHA evaluations. See Captcha Configuration below for details.
     */
    @JvmName("ojsbyriaetfjhpyo")
    public suspend fun captchaConfig(`value`: RuleGroupRuleCaptchaConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captchaConfig = mapped
    }

    /**
     * @param argument Specifies how AWS WAF should handle CAPTCHA evaluations. See Captcha Configuration below for details.
     */
    @JvmName("bmltmqrwjwjtoalo")
    public suspend
    fun captchaConfig(argument: suspend RuleGroupRuleCaptchaConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleCaptchaConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.captchaConfig = mapped
    }

    /**
     * @param value A friendly name of the rule.
     */
    @JvmName("rbkfvlyfyrtttucp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value If you define more than one Rule in a WebACL, AWS WAF evaluates each request against the `rules` in order based on the value of `priority`. AWS WAF processes rules with lower priority first.
     */
    @JvmName("rgekvscxjwsniptv")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Labels to apply to web requests that match the rule match statement. See Rule Label below for details.
     */
    @JvmName("hiuwytrtvklprogm")
    public suspend fun ruleLabels(`value`: List<RuleGroupRuleRuleLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleLabels = mapped
    }

    /**
     * @param argument Labels to apply to web requests that match the rule match statement. See Rule Label below for details.
     */
    @JvmName("ypbrapqhqqjeprhj")
    public suspend
    fun ruleLabels(argument: List<suspend RuleGroupRuleRuleLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleRuleLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleLabels = mapped
    }

    /**
     * @param argument Labels to apply to web requests that match the rule match statement. See Rule Label below for details.
     */
    @JvmName("piovyvwnplvwqgej")
    public suspend fun ruleLabels(
        vararg
        argument: suspend RuleGroupRuleRuleLabelArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleRuleLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleLabels = mapped
    }

    /**
     * @param argument Labels to apply to web requests that match the rule match statement. See Rule Label below for details.
     */
    @JvmName("fbrlnruloadkntiv")
    public suspend fun ruleLabels(argument: suspend RuleGroupRuleRuleLabelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuleGroupRuleRuleLabelArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ruleLabels = mapped
    }

    /**
     * @param values Labels to apply to web requests that match the rule match statement. See Rule Label below for details.
     */
    @JvmName("gbqfhuslxkhiwsnc")
    public suspend fun ruleLabels(vararg values: RuleGroupRuleRuleLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleLabels = mapped
    }

    /**
     * @param value The AWS WAF processing statement for the rule, for example `byte_match_statement` or `geo_match_statement`. See Statement below for details.
     */
    @JvmName("btruukaufwuuixcq")
    public suspend fun statement(`value`: RuleGroupRuleStatementArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statement = mapped
    }

    /**
     * @param argument The AWS WAF processing statement for the rule, for example `byte_match_statement` or `geo_match_statement`. See Statement below for details.
     */
    @JvmName("hpmhgcjlbsrupnbk")
    public suspend fun statement(argument: suspend RuleGroupRuleStatementArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.statement = mapped
    }

    /**
     * @param value Defines and enables Amazon CloudWatch metrics and web request sample collection. See Visibility Configuration below for details.
     */
    @JvmName("mggwoojtrjkanrpp")
    public suspend fun visibilityConfig(`value`: RuleGroupRuleVisibilityConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.visibilityConfig = mapped
    }

    /**
     * @param argument Defines and enables Amazon CloudWatch metrics and web request sample collection. See Visibility Configuration below for details.
     */
    @JvmName("tqbtedxosvyojwqh")
    public suspend
    fun visibilityConfig(argument: suspend RuleGroupRuleVisibilityConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleVisibilityConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.visibilityConfig = mapped
    }

    internal fun build(): RuleGroupRuleArgs = RuleGroupRuleArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        captchaConfig = captchaConfig,
        name = name ?: throw PulumiNullFieldException("name"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
        ruleLabels = ruleLabels,
        statement = statement ?: throw PulumiNullFieldException("statement"),
        visibilityConfig = visibilityConfig ?: throw PulumiNullFieldException("visibilityConfig"),
    )
}
