@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleRuleLabelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The label string.
 */
public data class RuleGroupRuleRuleLabelArgs(
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleRuleLabelArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleRuleLabelArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleRuleLabelArgs.builder()
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupRuleRuleLabelArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleRuleLabelArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value The label string.
     */
    @JvmName("sichxihhmllcvoef")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The label string.
     */
    @JvmName("fkaghpaonouuacrl")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): RuleGroupRuleRuleLabelArgs = RuleGroupRuleRuleLabelArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
