@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementAndStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property statements The statements to combine.
 */
public data class RuleGroupRuleStatementAndStatementArgs(
    public val statements: Output<List<RuleGroupRuleStatementArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementAndStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementAndStatementArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementAndStatementArgs.builder()
            .statements(
                statements.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementAndStatementArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementAndStatementArgsBuilder internal constructor() {
    private var statements: Output<List<RuleGroupRuleStatementArgs>>? = null

    /**
     * @param value The statements to combine.
     */
    @JvmName("gjckqcowjgtlynfo")
    public suspend fun statements(`value`: Output<List<RuleGroupRuleStatementArgs>>) {
        this.statements = value
    }

    @JvmName("fjuyhkrbydmlfyks")
    public suspend fun statements(vararg values: Output<RuleGroupRuleStatementArgs>) {
        this.statements = Output.all(values.asList())
    }

    /**
     * @param values The statements to combine.
     */
    @JvmName("ucssooxbufvcjneu")
    public suspend fun statements(values: List<Output<RuleGroupRuleStatementArgs>>) {
        this.statements = Output.all(values)
    }

    /**
     * @param value The statements to combine.
     */
    @JvmName("xnmikudfscytjgqr")
    public suspend fun statements(`value`: List<RuleGroupRuleStatementArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statements = mapped
    }

    /**
     * @param argument The statements to combine.
     */
    @JvmName("kmxaepnutremmnau")
    public suspend
    fun statements(argument: List<suspend RuleGroupRuleStatementArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param argument The statements to combine.
     */
    @JvmName("hxggdtjxspxddbto")
    public suspend fun statements(
        vararg
        argument: suspend RuleGroupRuleStatementArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param argument The statements to combine.
     */
    @JvmName("erlnpcqqoktmsgdn")
    public suspend fun statements(argument: suspend RuleGroupRuleStatementArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuleGroupRuleStatementArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param values The statements to combine.
     */
    @JvmName("megeygqlttosxjmv")
    public suspend fun statements(vararg values: RuleGroupRuleStatementArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statements = mapped
    }

    internal fun build(): RuleGroupRuleStatementAndStatementArgs =
        RuleGroupRuleStatementAndStatementArgs(
            statements = statements ?: throw PulumiNullFieldException("statements"),
        )
}
