@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property andStatement A logical rule statement used to combine other rule statements with AND logic. See AND Statement below for details.
 * @property byteMatchStatement A rule statement that defines a string match search for AWS WAF to apply to web requests. See Byte Match Statement below for details.
 * @property geoMatchStatement A rule statement used to identify web requests based on country of origin. See GEO Match Statement below for details.
 * @property ipSetReferenceStatement A rule statement used to detect web requests coming from particular IP addresses or address ranges. See IP Set Reference Statement below for details.
 * @property labelMatchStatement A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See Label Match Statement below for details.
 * @property notStatement A logical rule statement used to negate the results of another rule statement. See NOT Statement below for details.
 * @property orStatement A logical rule statement used to combine other rule statements with OR logic. See OR Statement below for details.
 * @property rateBasedStatement A rate-based rule tracks the rate of requests for each originating `IP address`, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any `5-minute` time span. This statement can not be nested. See Rate Based Statement below for details.
 * @property regexMatchStatement A rule statement used to search web request components for a match against a single regular expression. See Regex Match Statement below for details.
 * @property regexPatternSetReferenceStatement A rule statement used to search web request components for matches with regular expressions. See Regex Pattern Set Reference Statement below for details.
 * @property sizeConstraintStatement A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See Size Constraint Statement below for more details.
 * @property sqliMatchStatement An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See SQL Injection Match Statement below for details.
 * @property xssMatchStatement A rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See XSS Match Statement below for details.
 */
public data class RuleGroupRuleStatementArgs(
    public val andStatement: Output<RuleGroupRuleStatementAndStatementArgs>? = null,
    public val byteMatchStatement: Output<RuleGroupRuleStatementByteMatchStatementArgs>? = null,
    public val geoMatchStatement: Output<RuleGroupRuleStatementGeoMatchStatementArgs>? = null,
    public val ipSetReferenceStatement: Output<RuleGroupRuleStatementIpSetReferenceStatementArgs>? =
        null,
    public val labelMatchStatement: Output<RuleGroupRuleStatementLabelMatchStatementArgs>? = null,
    public val notStatement: Output<RuleGroupRuleStatementNotStatementArgs>? = null,
    public val orStatement: Output<RuleGroupRuleStatementOrStatementArgs>? = null,
    public val rateBasedStatement: Output<RuleGroupRuleStatementRateBasedStatementArgs>? = null,
    public val regexMatchStatement: Output<RuleGroupRuleStatementRegexMatchStatementArgs>? = null,
    public val regexPatternSetReferenceStatement:
    Output<RuleGroupRuleStatementRegexPatternSetReferenceStatementArgs>? = null,
    public val sizeConstraintStatement: Output<RuleGroupRuleStatementSizeConstraintStatementArgs>? =
        null,
    public val sqliMatchStatement: Output<RuleGroupRuleStatementSqliMatchStatementArgs>? = null,
    public val xssMatchStatement: Output<RuleGroupRuleStatementXssMatchStatementArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementArgs.builder()
            .andStatement(andStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .byteMatchStatement(
                byteMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .geoMatchStatement(geoMatchStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipSetReferenceStatement(
                ipSetReferenceStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .labelMatchStatement(
                labelMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .notStatement(notStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .orStatement(orStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rateBasedStatement(
                rateBasedStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .regexMatchStatement(
                regexMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .regexPatternSetReferenceStatement(
                regexPatternSetReferenceStatement?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .sizeConstraintStatement(
                sizeConstraintStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sqliMatchStatement(
                sqliMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .xssMatchStatement(
                xssMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementArgsBuilder internal constructor() {
    private var andStatement: Output<RuleGroupRuleStatementAndStatementArgs>? = null

    private var byteMatchStatement: Output<RuleGroupRuleStatementByteMatchStatementArgs>? = null

    private var geoMatchStatement: Output<RuleGroupRuleStatementGeoMatchStatementArgs>? = null

    private var ipSetReferenceStatement: Output<RuleGroupRuleStatementIpSetReferenceStatementArgs>? =
        null

    private var labelMatchStatement: Output<RuleGroupRuleStatementLabelMatchStatementArgs>? = null

    private var notStatement: Output<RuleGroupRuleStatementNotStatementArgs>? = null

    private var orStatement: Output<RuleGroupRuleStatementOrStatementArgs>? = null

    private var rateBasedStatement: Output<RuleGroupRuleStatementRateBasedStatementArgs>? = null

    private var regexMatchStatement: Output<RuleGroupRuleStatementRegexMatchStatementArgs>? = null

    private var regexPatternSetReferenceStatement:
        Output<RuleGroupRuleStatementRegexPatternSetReferenceStatementArgs>? = null

    private var sizeConstraintStatement: Output<RuleGroupRuleStatementSizeConstraintStatementArgs>? =
        null

    private var sqliMatchStatement: Output<RuleGroupRuleStatementSqliMatchStatementArgs>? = null

    private var xssMatchStatement: Output<RuleGroupRuleStatementXssMatchStatementArgs>? = null

    /**
     * @param value A logical rule statement used to combine other rule statements with AND logic. See AND Statement below for details.
     */
    @JvmName("myoavbmvcbuvknqh")
    public suspend fun andStatement(`value`: Output<RuleGroupRuleStatementAndStatementArgs>) {
        this.andStatement = value
    }

    /**
     * @param value A rule statement that defines a string match search for AWS WAF to apply to web requests. See Byte Match Statement below for details.
     */
    @JvmName("vjfrvsgxluuxincf")
    public suspend
    fun byteMatchStatement(`value`: Output<RuleGroupRuleStatementByteMatchStatementArgs>) {
        this.byteMatchStatement = value
    }

    /**
     * @param value A rule statement used to identify web requests based on country of origin. See GEO Match Statement below for details.
     */
    @JvmName("snoxiqtpnrecynlh")
    public suspend
    fun geoMatchStatement(`value`: Output<RuleGroupRuleStatementGeoMatchStatementArgs>) {
        this.geoMatchStatement = value
    }

    /**
     * @param value A rule statement used to detect web requests coming from particular IP addresses or address ranges. See IP Set Reference Statement below for details.
     */
    @JvmName("ddomjpgmfmjuqqtn")
    public suspend
    fun ipSetReferenceStatement(`value`: Output<RuleGroupRuleStatementIpSetReferenceStatementArgs>) {
        this.ipSetReferenceStatement = value
    }

    /**
     * @param value A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See Label Match Statement below for details.
     */
    @JvmName("elasfllcdhmcxvte")
    public suspend
    fun labelMatchStatement(`value`: Output<RuleGroupRuleStatementLabelMatchStatementArgs>) {
        this.labelMatchStatement = value
    }

    /**
     * @param value A logical rule statement used to negate the results of another rule statement. See NOT Statement below for details.
     */
    @JvmName("fumtbafilpglwmij")
    public suspend fun notStatement(`value`: Output<RuleGroupRuleStatementNotStatementArgs>) {
        this.notStatement = value
    }

    /**
     * @param value A logical rule statement used to combine other rule statements with OR logic. See OR Statement below for details.
     */
    @JvmName("uvlmahdqxtxpobys")
    public suspend fun orStatement(`value`: Output<RuleGroupRuleStatementOrStatementArgs>) {
        this.orStatement = value
    }

    /**
     * @param value A rate-based rule tracks the rate of requests for each originating `IP address`, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any `5-minute` time span. This statement can not be nested. See Rate Based Statement below for details.
     */
    @JvmName("modoacbyksdimlux")
    public suspend
    fun rateBasedStatement(`value`: Output<RuleGroupRuleStatementRateBasedStatementArgs>) {
        this.rateBasedStatement = value
    }

    /**
     * @param value A rule statement used to search web request components for a match against a single regular expression. See Regex Match Statement below for details.
     */
    @JvmName("kynwflfuivkffssr")
    public suspend
    fun regexMatchStatement(`value`: Output<RuleGroupRuleStatementRegexMatchStatementArgs>) {
        this.regexMatchStatement = value
    }

    /**
     * @param value A rule statement used to search web request components for matches with regular expressions. See Regex Pattern Set Reference Statement below for details.
     */
    @JvmName("jtijirrmigyhhqcw")
    public suspend
    fun regexPatternSetReferenceStatement(`value`: Output<RuleGroupRuleStatementRegexPatternSetReferenceStatementArgs>) {
        this.regexPatternSetReferenceStatement = value
    }

    /**
     * @param value A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See Size Constraint Statement below for more details.
     */
    @JvmName("mobaiarcbcngvteh")
    public suspend
    fun sizeConstraintStatement(`value`: Output<RuleGroupRuleStatementSizeConstraintStatementArgs>) {
        this.sizeConstraintStatement = value
    }

    /**
     * @param value An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See SQL Injection Match Statement below for details.
     */
    @JvmName("gthyfmjefaambpvs")
    public suspend
    fun sqliMatchStatement(`value`: Output<RuleGroupRuleStatementSqliMatchStatementArgs>) {
        this.sqliMatchStatement = value
    }

    /**
     * @param value A rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See XSS Match Statement below for details.
     */
    @JvmName("upeldcgricbwbbay")
    public suspend
    fun xssMatchStatement(`value`: Output<RuleGroupRuleStatementXssMatchStatementArgs>) {
        this.xssMatchStatement = value
    }

    /**
     * @param value A logical rule statement used to combine other rule statements with AND logic. See AND Statement below for details.
     */
    @JvmName("kplfvfhhvmqkbgpn")
    public suspend fun andStatement(`value`: RuleGroupRuleStatementAndStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.andStatement = mapped
    }

    /**
     * @param argument A logical rule statement used to combine other rule statements with AND logic. See AND Statement below for details.
     */
    @JvmName("xknyewlrwpepackb")
    public suspend
    fun andStatement(argument: suspend RuleGroupRuleStatementAndStatementArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementAndStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.andStatement = mapped
    }

    /**
     * @param value A rule statement that defines a string match search for AWS WAF to apply to web requests. See Byte Match Statement below for details.
     */
    @JvmName("ivyfylospnfqnexu")
    public suspend fun byteMatchStatement(`value`: RuleGroupRuleStatementByteMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.byteMatchStatement = mapped
    }

    /**
     * @param argument A rule statement that defines a string match search for AWS WAF to apply to web requests. See Byte Match Statement below for details.
     */
    @JvmName("ymfsbqxfqmiffvxj")
    public suspend
    fun byteMatchStatement(argument: suspend RuleGroupRuleStatementByteMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementByteMatchStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.byteMatchStatement = mapped
    }

    /**
     * @param value A rule statement used to identify web requests based on country of origin. See GEO Match Statement below for details.
     */
    @JvmName("iyqqlirjyritidho")
    public suspend fun geoMatchStatement(`value`: RuleGroupRuleStatementGeoMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoMatchStatement = mapped
    }

    /**
     * @param argument A rule statement used to identify web requests based on country of origin. See GEO Match Statement below for details.
     */
    @JvmName("fkestsiuwfrxxujm")
    public suspend
    fun geoMatchStatement(argument: suspend RuleGroupRuleStatementGeoMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementGeoMatchStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.geoMatchStatement = mapped
    }

    /**
     * @param value A rule statement used to detect web requests coming from particular IP addresses or address ranges. See IP Set Reference Statement below for details.
     */
    @JvmName("ymqfexjbdhbrvvlm")
    public suspend
    fun ipSetReferenceStatement(`value`: RuleGroupRuleStatementIpSetReferenceStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSetReferenceStatement = mapped
    }

    /**
     * @param argument A rule statement used to detect web requests coming from particular IP addresses or address ranges. See IP Set Reference Statement below for details.
     */
    @JvmName("ilxcsmlofacwswdf")
    public suspend
    fun ipSetReferenceStatement(argument: suspend RuleGroupRuleStatementIpSetReferenceStatementArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementIpSetReferenceStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ipSetReferenceStatement = mapped
    }

    /**
     * @param value A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See Label Match Statement below for details.
     */
    @JvmName("cskdcbrmduwltfbe")
    public suspend fun labelMatchStatement(`value`: RuleGroupRuleStatementLabelMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelMatchStatement = mapped
    }

    /**
     * @param argument A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See Label Match Statement below for details.
     */
    @JvmName("riqbpjyvpesddsek")
    public suspend
    fun labelMatchStatement(argument: suspend RuleGroupRuleStatementLabelMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementLabelMatchStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.labelMatchStatement = mapped
    }

    /**
     * @param value A logical rule statement used to negate the results of another rule statement. See NOT Statement below for details.
     */
    @JvmName("lecgacctmpbdbhwk")
    public suspend fun notStatement(`value`: RuleGroupRuleStatementNotStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notStatement = mapped
    }

    /**
     * @param argument A logical rule statement used to negate the results of another rule statement. See NOT Statement below for details.
     */
    @JvmName("lyrfnbktdoqyeiwt")
    public suspend
    fun notStatement(argument: suspend RuleGroupRuleStatementNotStatementArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementNotStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.notStatement = mapped
    }

    /**
     * @param value A logical rule statement used to combine other rule statements with OR logic. See OR Statement below for details.
     */
    @JvmName("vupotqnheioxefpa")
    public suspend fun orStatement(`value`: RuleGroupRuleStatementOrStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orStatement = mapped
    }

    /**
     * @param argument A logical rule statement used to combine other rule statements with OR logic. See OR Statement below for details.
     */
    @JvmName("iybmupkqxjqighfh")
    public suspend
    fun orStatement(argument: suspend RuleGroupRuleStatementOrStatementArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementOrStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.orStatement = mapped
    }

    /**
     * @param value A rate-based rule tracks the rate of requests for each originating `IP address`, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any `5-minute` time span. This statement can not be nested. See Rate Based Statement below for details.
     */
    @JvmName("mllgwgtvrxykmlhg")
    public suspend fun rateBasedStatement(`value`: RuleGroupRuleStatementRateBasedStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateBasedStatement = mapped
    }

    /**
     * @param argument A rate-based rule tracks the rate of requests for each originating `IP address`, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any `5-minute` time span. This statement can not be nested. See Rate Based Statement below for details.
     */
    @JvmName("dvsfviivfjmtywuf")
    public suspend
    fun rateBasedStatement(argument: suspend RuleGroupRuleStatementRateBasedStatementArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementRateBasedStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rateBasedStatement = mapped
    }

    /**
     * @param value A rule statement used to search web request components for a match against a single regular expression. See Regex Match Statement below for details.
     */
    @JvmName("pvadpshfdmfsamkv")
    public suspend fun regexMatchStatement(`value`: RuleGroupRuleStatementRegexMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexMatchStatement = mapped
    }

    /**
     * @param argument A rule statement used to search web request components for a match against a single regular expression. See Regex Match Statement below for details.
     */
    @JvmName("vpjiykyvbyggtaqt")
    public suspend
    fun regexMatchStatement(argument: suspend RuleGroupRuleStatementRegexMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementRegexMatchStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.regexMatchStatement = mapped
    }

    /**
     * @param value A rule statement used to search web request components for matches with regular expressions. See Regex Pattern Set Reference Statement below for details.
     */
    @JvmName("nlkedlhqpfowehda")
    public suspend
    fun regexPatternSetReferenceStatement(`value`: RuleGroupRuleStatementRegexPatternSetReferenceStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexPatternSetReferenceStatement = mapped
    }

    /**
     * @param argument A rule statement used to search web request components for matches with regular expressions. See Regex Pattern Set Reference Statement below for details.
     */
    @JvmName("rqyluplcbfvwmosh")
    public suspend
    fun regexPatternSetReferenceStatement(argument: suspend RuleGroupRuleStatementRegexPatternSetReferenceStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRegexPatternSetReferenceStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.regexPatternSetReferenceStatement = mapped
    }

    /**
     * @param value A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See Size Constraint Statement below for more details.
     */
    @JvmName("bitpmmefcjuvmuxq")
    public suspend
    fun sizeConstraintStatement(`value`: RuleGroupRuleStatementSizeConstraintStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeConstraintStatement = mapped
    }

    /**
     * @param argument A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See Size Constraint Statement below for more details.
     */
    @JvmName("lmkajlhoobwqhwfa")
    public suspend
    fun sizeConstraintStatement(argument: suspend RuleGroupRuleStatementSizeConstraintStatementArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementSizeConstraintStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sizeConstraintStatement = mapped
    }

    /**
     * @param value An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See SQL Injection Match Statement below for details.
     */
    @JvmName("quehqbgmmrwanobg")
    public suspend fun sqliMatchStatement(`value`: RuleGroupRuleStatementSqliMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqliMatchStatement = mapped
    }

    /**
     * @param argument An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See SQL Injection Match Statement below for details.
     */
    @JvmName("uelrokdprewogopb")
    public suspend
    fun sqliMatchStatement(argument: suspend RuleGroupRuleStatementSqliMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementSqliMatchStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sqliMatchStatement = mapped
    }

    /**
     * @param value A rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See XSS Match Statement below for details.
     */
    @JvmName("ayjphyhsmdjvvrhn")
    public suspend fun xssMatchStatement(`value`: RuleGroupRuleStatementXssMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xssMatchStatement = mapped
    }

    /**
     * @param argument A rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See XSS Match Statement below for details.
     */
    @JvmName("paihfnwxcdatttam")
    public suspend
    fun xssMatchStatement(argument: suspend RuleGroupRuleStatementXssMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementXssMatchStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.xssMatchStatement = mapped
    }

    internal fun build(): RuleGroupRuleStatementArgs = RuleGroupRuleStatementArgs(
        andStatement = andStatement,
        byteMatchStatement = byteMatchStatement,
        geoMatchStatement = geoMatchStatement,
        ipSetReferenceStatement = ipSetReferenceStatement,
        labelMatchStatement = labelMatchStatement,
        notStatement = notStatement,
        orStatement = orStatement,
        rateBasedStatement = rateBasedStatement,
        regexMatchStatement = regexMatchStatement,
        regexPatternSetReferenceStatement = regexPatternSetReferenceStatement,
        sizeConstraintStatement = sizeConstraintStatement,
        sqliMatchStatement = sqliMatchStatement,
        xssMatchStatement = xssMatchStatement,
    )
}
