@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementIpSetReferenceStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the IP Set that this statement references.
 * @property ipSetForwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See IPSet Forwarded IP Config below for more details.
 */
public data class RuleGroupRuleStatementIpSetReferenceStatementArgs(
    public val arn: Output<String>,
    public val ipSetForwardedIpConfig:
    Output<RuleGroupRuleStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementIpSetReferenceStatementArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementIpSetReferenceStatementArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementIpSetReferenceStatementArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .ipSetForwardedIpConfig(
                ipSetForwardedIpConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementIpSetReferenceStatementArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementIpSetReferenceStatementArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var ipSetForwardedIpConfig:
        Output<RuleGroupRuleStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the IP Set that this statement references.
     */
    @JvmName("wemebiooccartbby")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See IPSet Forwarded IP Config below for more details.
     */
    @JvmName("syobxgbdaigfehdn")
    public suspend
    fun ipSetForwardedIpConfig(`value`: Output<RuleGroupRuleStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs>) {
        this.ipSetForwardedIpConfig = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IP Set that this statement references.
     */
    @JvmName("iinrhejidykplgds")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See IPSet Forwarded IP Config below for more details.
     */
    @JvmName("pfoxvhxkpgpwpicj")
    public suspend
    fun ipSetForwardedIpConfig(`value`: RuleGroupRuleStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSetForwardedIpConfig = mapped
    }

    /**
     * @param argument The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See IPSet Forwarded IP Config below for more details.
     */
    @JvmName("vjhpikolquoidpuf")
    public suspend
    fun ipSetForwardedIpConfig(argument: suspend RuleGroupRuleStatementIpSetReferenceStatementIpSetForwardedIpConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementIpSetReferenceStatementIpSetForwardedIpConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ipSetForwardedIpConfig = mapped
    }

    internal fun build(): RuleGroupRuleStatementIpSetReferenceStatementArgs =
        RuleGroupRuleStatementIpSetReferenceStatementArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
            ipSetForwardedIpConfig = ipSetForwardedIpConfig,
        )
}
