@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property aggregateKeyType Setting that indicates how to aggregate the request counts. Valid values include: `CONSTANT`, `CUSTOM_KEYS`, `FORWARDED_IP` or `IP`. Default: `IP`.
 * @property customKeys Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
 * @property forwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. If `aggregate_key_type` is set to `FORWARDED_IP`, this block is required. See Forwarded IP Config below for details.
 * @property limit The limit on requests per 5-minute period for a single originating IP address.
 * @property scopeDownStatement An optional nested statement that narrows the scope of the rate-based statement to matching web requests. This can be any nestable statement, and you can nest statements at any level below this scope-down statement. See Statement above for details. If `aggregate_key_type` is set to `CONSTANT`, this block is required.
 */
public data class RuleGroupRuleStatementRateBasedStatementArgs(
    public val aggregateKeyType: Output<String>? = null,
    public val customKeys: Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyArgs>>? =
        null,
    public val forwardedIpConfig:
    Output<RuleGroupRuleStatementRateBasedStatementForwardedIpConfigArgs>? = null,
    public val limit: Output<Int>,
    public val scopeDownStatement:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementArgs.builder()
            .aggregateKeyType(aggregateKeyType?.applyValue({ args0 -> args0 }))
            .customKeys(
                customKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .forwardedIpConfig(forwardedIpConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .limit(limit.applyValue({ args0 -> args0 }))
            .scopeDownStatement(
                scopeDownStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementRateBasedStatementArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementRateBasedStatementArgsBuilder internal constructor() {
    private var aggregateKeyType: Output<String>? = null

    private var customKeys: Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyArgs>>? =
        null

    private var forwardedIpConfig:
        Output<RuleGroupRuleStatementRateBasedStatementForwardedIpConfigArgs>? = null

    private var limit: Output<Int>? = null

    private var scopeDownStatement:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementArgs>? = null

    /**
     * @param value Setting that indicates how to aggregate the request counts. Valid values include: `CONSTANT`, `CUSTOM_KEYS`, `FORWARDED_IP` or `IP`. Default: `IP`.
     */
    @JvmName("smrlfafdrshaabcg")
    public suspend fun aggregateKeyType(`value`: Output<String>) {
        this.aggregateKeyType = value
    }

    /**
     * @param value Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
     */
    @JvmName("tbfwmadcenneuotr")
    public suspend
    fun customKeys(`value`: Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyArgs>>) {
        this.customKeys = value
    }

    @JvmName("hopmgthxlfkxvgsj")
    public suspend fun customKeys(
        vararg
        values: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyArgs>,
    ) {
        this.customKeys = Output.all(values.asList())
    }

    /**
     * @param values Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
     */
    @JvmName("pwgmntvshjvnomkv")
    public suspend
    fun customKeys(values: List<Output<RuleGroupRuleStatementRateBasedStatementCustomKeyArgs>>) {
        this.customKeys = Output.all(values)
    }

    /**
     * @param value The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. If `aggregate_key_type` is set to `FORWARDED_IP`, this block is required. See Forwarded IP Config below for details.
     */
    @JvmName("qmldeycnxgtdmqcf")
    public suspend
    fun forwardedIpConfig(`value`: Output<RuleGroupRuleStatementRateBasedStatementForwardedIpConfigArgs>) {
        this.forwardedIpConfig = value
    }

    /**
     * @param value The limit on requests per 5-minute period for a single originating IP address.
     */
    @JvmName("bqitdyaokhcobvij")
    public suspend fun limit(`value`: Output<Int>) {
        this.limit = value
    }

    /**
     * @param value An optional nested statement that narrows the scope of the rate-based statement to matching web requests. This can be any nestable statement, and you can nest statements at any level below this scope-down statement. See Statement above for details. If `aggregate_key_type` is set to `CONSTANT`, this block is required.
     */
    @JvmName("lcklterovjixfrbo")
    public suspend
    fun scopeDownStatement(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementArgs>) {
        this.scopeDownStatement = value
    }

    /**
     * @param value Setting that indicates how to aggregate the request counts. Valid values include: `CONSTANT`, `CUSTOM_KEYS`, `FORWARDED_IP` or `IP`. Default: `IP`.
     */
    @JvmName("iqiyoxfbopylbrnq")
    public suspend fun aggregateKeyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregateKeyType = mapped
    }

    /**
     * @param value Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
     */
    @JvmName("jcrsknsfaegrfyik")
    public suspend
    fun customKeys(`value`: List<RuleGroupRuleStatementRateBasedStatementCustomKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customKeys = mapped
    }

    /**
     * @param argument Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
     */
    @JvmName("ttvgndmsdxvcprql")
    public suspend
    fun customKeys(argument: List<suspend RuleGroupRuleStatementRateBasedStatementCustomKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRateBasedStatementCustomKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customKeys = mapped
    }

    /**
     * @param argument Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
     */
    @JvmName("sxojaxlppuocnpur")
    public suspend fun customKeys(
        vararg
        argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRateBasedStatementCustomKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customKeys = mapped
    }

    /**
     * @param argument Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
     */
    @JvmName("jxyanirdacdqtiec")
    public suspend
    fun customKeys(argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementRateBasedStatementCustomKeyArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.customKeys = mapped
    }

    /**
     * @param values Aggregate the request counts using one or more web request components as the aggregate keys. See `custom_key` below for details.
     */
    @JvmName("mhlhvgswiiiyqbqn")
    public suspend fun customKeys(
        vararg
        values: RuleGroupRuleStatementRateBasedStatementCustomKeyArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customKeys = mapped
    }

    /**
     * @param value The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. If `aggregate_key_type` is set to `FORWARDED_IP`, this block is required. See Forwarded IP Config below for details.
     */
    @JvmName("ehujbkeuorlgeukm")
    public suspend
    fun forwardedIpConfig(`value`: RuleGroupRuleStatementRateBasedStatementForwardedIpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedIpConfig = mapped
    }

    /**
     * @param argument The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. If `aggregate_key_type` is set to `FORWARDED_IP`, this block is required. See Forwarded IP Config below for details.
     */
    @JvmName("wkusckjqqpnsdjrg")
    public suspend
    fun forwardedIpConfig(argument: suspend RuleGroupRuleStatementRateBasedStatementForwardedIpConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementForwardedIpConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.forwardedIpConfig = mapped
    }

    /**
     * @param value The limit on requests per 5-minute period for a single originating IP address.
     */
    @JvmName("tqxctktmqlqbskka")
    public suspend fun limit(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.limit = mapped
    }

    /**
     * @param value An optional nested statement that narrows the scope of the rate-based statement to matching web requests. This can be any nestable statement, and you can nest statements at any level below this scope-down statement. See Statement above for details. If `aggregate_key_type` is set to `CONSTANT`, this block is required.
     */
    @JvmName("htidwpxkuqrulrke")
    public suspend
    fun scopeDownStatement(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeDownStatement = mapped
    }

    /**
     * @param argument An optional nested statement that narrows the scope of the rate-based statement to matching web requests. This can be any nestable statement, and you can nest statements at any level below this scope-down statement. See Statement above for details. If `aggregate_key_type` is set to `CONSTANT`, this block is required.
     */
    @JvmName("dsuamhxhaoiprjhu")
    public suspend
    fun scopeDownStatement(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.scopeDownStatement = mapped
    }

    internal fun build(): RuleGroupRuleStatementRateBasedStatementArgs =
        RuleGroupRuleStatementRateBasedStatementArgs(
            aggregateKeyType = aggregateKeyType,
            customKeys = customKeys,
            forwardedIpConfig = forwardedIpConfig,
            limit = limit ?: throw PulumiNullFieldException("limit"),
            scopeDownStatement = scopeDownStatement,
        )
}
