@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cookie (Optional) Use the value of a cookie in the request as an aggregate key. See RateLimit `cookie` below for details.
 * @property forwardedIp (Optional) Use the first IP address in an HTTP header as an aggregate key. See `forwarded_ip` below for details.
 * @property header (Optional) Use the value of a header in the request as an aggregate key. See RateLimit `header` below for details.
 * @property httpMethod (Optional) Use the request's HTTP method as an aggregate key. See RateLimit `http_method` below for details.
 * @property ip (Optional) Use the request's originating IP address as an aggregate key. See `RateLimit ip` below for details.
 * @property labelNamespace (Optional) Use the specified label namespace as an aggregate key. See RateLimit `label_namespace` below for details.
 * @property queryArgument (Optional) Use the specified query argument as an aggregate key. See RateLimit `query_argument` below for details.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class RuleGroupRuleStatementRateBasedStatementCustomKeyArgs(
    public val cookie: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyCookieArgs>? = null,
    public val forwardedIp: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyForwardedIpArgs>? =
        null,
    public val `header`: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderArgs>? = null,
    public val httpMethod: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyHttpMethodArgs>? =
        null,
    public val ip: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyIpArgs>? = null,
    public val labelNamespace:
    Output<RuleGroupRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgs>? = null,
    public val queryArgument:
    Output<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs>? = null,
    public val queryString: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringArgs>? =
        null,
    public val uriPath: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyArgs.builder()
            .cookie(cookie?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .forwardedIp(forwardedIp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .`header`(`header`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpMethod(httpMethod?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ip(ip?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .labelNamespace(labelNamespace?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryArgument(queryArgument?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RuleGroupRuleStatementRateBasedStatementCustomKeyArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementRateBasedStatementCustomKeyArgsBuilder internal constructor() {
    private var cookie: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyCookieArgs>? = null

    private var forwardedIp: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyForwardedIpArgs>? =
        null

    private var `header`: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderArgs>? = null

    private var httpMethod: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyHttpMethodArgs>? =
        null

    private var ip: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyIpArgs>? = null

    private var labelNamespace:
        Output<RuleGroupRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgs>? = null

    private var queryArgument:
        Output<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs>? = null

    private var queryString: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringArgs>? =
        null

    private var uriPath: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathArgs>? = null

    /**
     * @param value (Optional) Use the value of a cookie in the request as an aggregate key. See RateLimit `cookie` below for details.
     */
    @JvmName("yovpxraehnibipwc")
    public suspend
    fun cookie(`value`: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyCookieArgs>) {
        this.cookie = value
    }

    /**
     * @param value (Optional) Use the first IP address in an HTTP header as an aggregate key. See `forwarded_ip` below for details.
     */
    @JvmName("swhifwjydxrwomke")
    public suspend
    fun forwardedIp(`value`: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyForwardedIpArgs>) {
        this.forwardedIp = value
    }

    /**
     * @param value (Optional) Use the value of a header in the request as an aggregate key. See RateLimit `header` below for details.
     */
    @JvmName("nfkvvmimbuxwvqxo")
    public suspend
    fun `header`(`value`: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderArgs>) {
        this.`header` = value
    }

    /**
     * @param value (Optional) Use the request's HTTP method as an aggregate key. See RateLimit `http_method` below for details.
     */
    @JvmName("hpklanpgptcvnwpb")
    public suspend
    fun httpMethod(`value`: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyHttpMethodArgs>) {
        this.httpMethod = value
    }

    /**
     * @param value (Optional) Use the request's originating IP address as an aggregate key. See `RateLimit ip` below for details.
     */
    @JvmName("apuknwpuikpyfefy")
    public suspend fun ip(`value`: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyIpArgs>) {
        this.ip = value
    }

    /**
     * @param value (Optional) Use the specified label namespace as an aggregate key. See RateLimit `label_namespace` below for details.
     */
    @JvmName("lrrfwtsobqirdqiu")
    public suspend
    fun labelNamespace(`value`: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgs>) {
        this.labelNamespace = value
    }

    /**
     * @param value (Optional) Use the specified query argument as an aggregate key. See RateLimit `query_argument` below for details.
     */
    @JvmName("bcifdcarimgvifip")
    public suspend
    fun queryArgument(`value`: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs>) {
        this.queryArgument = value
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("rvnclaniuqgyuydu")
    public suspend
    fun queryString(`value`: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("tlygcrxvgkooyyja")
    public suspend
    fun uriPath(`value`: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value (Optional) Use the value of a cookie in the request as an aggregate key. See RateLimit `cookie` below for details.
     */
    @JvmName("evgmtlgfknwfiwla")
    public suspend fun cookie(`value`: RuleGroupRuleStatementRateBasedStatementCustomKeyCookieArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookie = mapped
    }

    /**
     * @param argument (Optional) Use the value of a cookie in the request as an aggregate key. See RateLimit `cookie` below for details.
     */
    @JvmName("jnitjvkfqadmcvbn")
    public suspend
    fun cookie(argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyCookieArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementCustomKeyCookieArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookie = mapped
    }

    /**
     * @param value (Optional) Use the first IP address in an HTTP header as an aggregate key. See `forwarded_ip` below for details.
     */
    @JvmName("mmhyqiohvylekgay")
    public suspend
    fun forwardedIp(`value`: RuleGroupRuleStatementRateBasedStatementCustomKeyForwardedIpArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedIp = mapped
    }

    /**
     * @param argument (Optional) Use the first IP address in an HTTP header as an aggregate key. See `forwarded_ip` below for details.
     */
    @JvmName("mgwbjhwuosmahiql")
    public suspend
    fun forwardedIp(argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyForwardedIpArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementCustomKeyForwardedIpArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.forwardedIp = mapped
    }

    /**
     * @param value (Optional) Use the value of a header in the request as an aggregate key. See RateLimit `header` below for details.
     */
    @JvmName("drecbqejowxcufgb")
    public suspend
    fun `header`(`value`: RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`header` = mapped
    }

    /**
     * @param argument (Optional) Use the value of a header in the request as an aggregate key. See RateLimit `header` below for details.
     */
    @JvmName("ppbuwuibmhtosbvq")
    public suspend
    fun `header`(argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.`header` = mapped
    }

    /**
     * @param value (Optional) Use the request's HTTP method as an aggregate key. See RateLimit `http_method` below for details.
     */
    @JvmName("urxxtdxbicouiojn")
    public suspend
    fun httpMethod(`value`: RuleGroupRuleStatementRateBasedStatementCustomKeyHttpMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpMethod = mapped
    }

    /**
     * @param argument (Optional) Use the request's HTTP method as an aggregate key. See RateLimit `http_method` below for details.
     */
    @JvmName("nsamcsccjqsnhsti")
    public suspend
    fun httpMethod(argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyHttpMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementCustomKeyHttpMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.httpMethod = mapped
    }

    /**
     * @param value (Optional) Use the request's originating IP address as an aggregate key. See `RateLimit ip` below for details.
     */
    @JvmName("awpwtaqopmxuytnj")
    public suspend fun ip(`value`: RuleGroupRuleStatementRateBasedStatementCustomKeyIpArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param argument (Optional) Use the request's originating IP address as an aggregate key. See `RateLimit ip` below for details.
     */
    @JvmName("nafsxxvpojoqjdtn")
    public suspend
    fun ip(argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyIpArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementRateBasedStatementCustomKeyIpArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ip = mapped
    }

    /**
     * @param value (Optional) Use the specified label namespace as an aggregate key. See RateLimit `label_namespace` below for details.
     */
    @JvmName("fljtarwlbuidiqly")
    public suspend
    fun labelNamespace(`value`: RuleGroupRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelNamespace = mapped
    }

    /**
     * @param argument (Optional) Use the specified label namespace as an aggregate key. See RateLimit `label_namespace` below for details.
     */
    @JvmName("kltxoyjycwtmaqcd")
    public suspend
    fun labelNamespace(argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.labelNamespace = mapped
    }

    /**
     * @param value (Optional) Use the specified query argument as an aggregate key. See RateLimit `query_argument` below for details.
     */
    @JvmName("jqpururjqgyyxrif")
    public suspend
    fun queryArgument(`value`: RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryArgument = mapped
    }

    /**
     * @param argument (Optional) Use the specified query argument as an aggregate key. See RateLimit `query_argument` below for details.
     */
    @JvmName("sdtpuvvarerquqfi")
    public suspend
    fun queryArgument(argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryArgument = mapped
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("edwttrgerakywlcc")
    public suspend
    fun queryString(`value`: RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("efsnyavxmwycwffr")
    public suspend
    fun queryString(argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("mfgkpiapcrfowrnn")
    public suspend
    fun uriPath(`value`: RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("acmpptuwkqhgiejp")
    public suspend
    fun uriPath(argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build(): RuleGroupRuleStatementRateBasedStatementCustomKeyArgs =
        RuleGroupRuleStatementRateBasedStatementCustomKeyArgs(
            cookie = cookie,
            forwardedIp = forwardedIp,
            `header` = `header`,
            httpMethod = httpMethod,
            ip = ip,
            labelNamespace = labelNamespace,
            queryArgument = queryArgument,
            queryString = queryString,
            uriPath = uriPath,
        )
}
