@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyCookieArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name A friendly name of the rule group.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
 * At least one required.
 * See Text Transformation below for details.
 */
public data class RuleGroupRuleStatementRateBasedStatementCustomKeyCookieArgs(
    public val name: Output<String>,
    public val textTransformations:
    Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyCookieArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyCookieArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyCookieArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementRateBasedStatementCustomKeyCookieArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementRateBasedStatementCustomKeyCookieArgsBuilder internal
constructor() {
    private var name: Output<String>? = null

    private var textTransformations:
        Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgs>>? =
        null

    /**
     * @param value A friendly name of the rule group.
     */
    @JvmName("enjnegikppbfewaa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("jsmhiwujkkudwybp")
    public suspend
    fun textTransformations(`value`: Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("dtxfghjhhlvmkgrd")
    public suspend fun textTransformations(
        vararg
        values: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgs>,
    ) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("oqwistblqmrdedhq")
    public suspend
    fun textTransformations(values: List<Output<RuleGroupRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value A friendly name of the rule group.
     */
    @JvmName("vbsafkxhagasdpwx")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("tahdcttnebfassik")
    public suspend
    fun textTransformations(`value`: List<RuleGroupRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("shaxtelbjqgdagep")
    public suspend
    fun textTransformations(argument: List<suspend RuleGroupRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("njtspdbmjykcgwhw")
    public suspend fun textTransformations(
        vararg
        argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("lhtfqcebmfhtovbo")
    public suspend
    fun textTransformations(argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("hlcmthtrphrccljd")
    public suspend fun textTransformations(
        vararg
        values: RuleGroupRuleStatementRateBasedStatementCustomKeyCookieTextTransformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): RuleGroupRuleStatementRateBasedStatementCustomKeyCookieArgs =
        RuleGroupRuleStatementRateBasedStatementCustomKeyCookieArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
