@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name A friendly name of the rule group.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
 * At least one required.
 * See Text Transformation below for details.
 */
public data class RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderArgs(
    public val name: Output<String>,
    public val textTransformations:
    Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderArgsBuilder internal
constructor() {
    private var name: Output<String>? = null

    private var textTransformations:
        Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgs>>? =
        null

    /**
     * @param value A friendly name of the rule group.
     */
    @JvmName("jwsjwiqlncqyeqlc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("hikvnljmvdavfevx")
    public suspend
    fun textTransformations(`value`: Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("abfssxrkmatesxsk")
    public suspend fun textTransformations(
        vararg
        values: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgs>,
    ) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("jcyjnjpcxmfpgnvp")
    public suspend
    fun textTransformations(values: List<Output<RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value A friendly name of the rule group.
     */
    @JvmName("aucavcwvqhmcunpi")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("mfdmviewjuqidoqm")
    public suspend
    fun textTransformations(`value`: List<RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("dknmspjrrigsprku")
    public suspend
    fun textTransformations(argument: List<suspend RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("nipiuefdttvoshlr")
    public suspend fun textTransformations(
        vararg
        argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("uhtcutkmemqtraqv")
    public suspend
    fun textTransformations(argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("aamtqltjttmsxggd")
    public suspend fun textTransformations(
        vararg
        values: RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderTextTransformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderArgs =
        RuleGroupRuleStatementRateBasedStatementCustomKeyHeaderArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
