@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name A friendly name of the rule group.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
 * At least one required.
 * See Text Transformation below for details.
 */
public data class RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs(
    public val name: Output<String>,
    public val textTransformations:
    Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentArgsBuilder internal
constructor() {
    private var name: Output<String>? = null

    private var textTransformations:
        Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgs>>? =
        null

    /**
     * @param value A friendly name of the rule group.
     */
    @JvmName("cjhcjkvtwdjgcntd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("dejlveuurqvcibmh")
    public suspend
    fun textTransformations(`value`: Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("bcxnftrcrrsoiwbu")
    public suspend fun textTransformations(
        vararg
        values: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgs>,
    ) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("vryhhawkrefartrp")
    public suspend
    fun textTransformations(values: List<Output<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value A friendly name of the rule group.
     */
    @JvmName("xnbydgcnlvkaycwo")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("yexckgyffdwysjvi")
    public suspend
    fun textTransformations(`value`: List<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("leekijnbajgamqar")
    public suspend
    fun textTransformations(argument: List<suspend RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("wkgxpyovsxftycpu")
    public suspend fun textTransformations(
        vararg
        argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("micrlgxssdyqxgca")
    public suspend
    fun textTransformations(argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("dwhigdbwqybmkdma")
    public suspend fun textTransformations(
        vararg
        values: RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs =
        RuleGroupRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
