@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
 * At least one required.
 * See Text Transformation below for details.
 */
public data class RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringArgs(
    public val textTransformations:
    Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringArgs.builder()
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringArgsBuilder internal
constructor() {
    private var textTransformations:
        Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgs>>? =
        null

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("knyeklvaxchvfjle")
    public suspend
    fun textTransformations(`value`: Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("qufmtvfjdrnospja")
    public suspend fun textTransformations(
        vararg
        values: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgs>,
    ) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("lmdpocdsmwqtaxub")
    public suspend
    fun textTransformations(values: List<Output<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("woceawyeaxaccltf")
    public suspend
    fun textTransformations(`value`: List<RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("kqmwxtuqwshybimc")
    public suspend
    fun textTransformations(argument: List<suspend RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("yrdfmlvksbmudsmd")
    public suspend fun textTransformations(
        vararg
        argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("jxjpgshkxpxmkkaf")
    public suspend
    fun textTransformations(argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("gnlrfxixbbnajnjk")
    public suspend fun textTransformations(
        vararg
        values: RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringTextTransformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringArgs =
        RuleGroupRuleStatementRateBasedStatementCustomKeyQueryStringArgs(
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
