@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers.
 * @property cookies Inspect the cookies in the web request. See Cookies below for details.
 * @property headers Inspect the request headers. See Headers below for details.
 * @property ja3Fingerprint
 * @property jsonBody Inspect the request body as JSON. See JSON Body for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See Single Header below for details.
 * @property singleQueryArgument Inspect a single query argument. See Single Query Argument below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class
RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchArgs(
    public val allQueryArguments:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchAllQueryArgumentsArgs>? =
        null,
    public val body:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchBodyArgs>? =
        null,
    public val cookies:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchCookiesArgs>? =
        null,
    public val headers:
    Output<List<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderArgs>>? =
        null,
    public val ja3Fingerprint:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchJa3FingerprintArgs>? =
        null,
    public val jsonBody:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchJsonBodyArgs>? =
        null,
    public val method:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchMethodArgs>? =
        null,
    public val queryString:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchQueryStringArgs>? =
        null,
    public val singleHeader:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchSingleHeaderArgs>? =
        null,
    public val singleQueryArgument:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchSingleQueryArgumentArgs>? =
        null,
    public val uriPath:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchUriPathArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchArgs.builder()
            .allQueryArguments(allQueryArguments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ja3Fingerprint(ja3Fingerprint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jsonBody(jsonBody?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleHeader(singleHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleQueryArgument(
                singleQueryArgument?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchArgs].
 */
@PulumiTagMarker
public class
RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchArgsBuilder
internal constructor() {
    private var allQueryArguments:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchAllQueryArgumentsArgs>? =
        null

    private var body:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchBodyArgs>? =
        null

    private var cookies:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchCookiesArgs>? =
        null

    private var headers:
        Output<List<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderArgs>>? =
        null

    private var ja3Fingerprint:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchJa3FingerprintArgs>? =
        null

    private var jsonBody:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchJsonBodyArgs>? =
        null

    private var method:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchMethodArgs>? =
        null

    private var queryString:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchQueryStringArgs>? =
        null

    private var singleHeader:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchSingleHeaderArgs>? =
        null

    private var singleQueryArgument:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchSingleQueryArgumentArgs>? =
        null

    private var uriPath:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchUriPathArgs>? =
        null

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("jueuwqryoetkmlht")
    public suspend
    fun allQueryArguments(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchAllQueryArgumentsArgs>) {
        this.allQueryArguments = value
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("edanjimktldafdea")
    public suspend
    fun body(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchBodyArgs>) {
        this.body = value
    }

    /**
     * @param value Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("elgjoeqyyfmsdhgq")
    public suspend
    fun cookies(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Inspect the request headers. See Headers below for details.
     */
    @JvmName("kiyovoxxclbecqke")
    public suspend
    fun headers(`value`: Output<List<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("ikhbdhmhwrnmhpvb")
    public suspend fun headers(
        vararg
        values: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderArgs>,
    ) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See Headers below for details.
     */
    @JvmName("gxibynsqaluurhsm")
    public suspend
    fun headers(values: List<Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kougkrwtvxvrolee")
    public suspend
    fun ja3Fingerprint(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchJa3FingerprintArgs>) {
        this.ja3Fingerprint = value
    }

    /**
     * @param value Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("whgsfxwwrmwxmiba")
    public suspend
    fun jsonBody(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchJsonBodyArgs>) {
        this.jsonBody = value
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("kbomhlanqktaejll")
    public suspend
    fun method(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchMethodArgs>) {
        this.method = value
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("envdtmooxxbxmnnl")
    public suspend
    fun queryString(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Inspect a single header. See Single Header below for details.
     */
    @JvmName("mcyptpfwcrakjojl")
    public suspend
    fun singleHeader(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchSingleHeaderArgs>) {
        this.singleHeader = value
    }

    /**
     * @param value Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("ykifkmvpuhsuehio")
    public suspend
    fun singleQueryArgument(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchSingleQueryArgumentArgs>) {
        this.singleQueryArgument = value
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("xuaehtfckulohuqw")
    public suspend
    fun uriPath(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("tpibtfqnyykxnpfi")
    public suspend
    fun allQueryArguments(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchAllQueryArgumentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allQueryArguments = mapped
    }

    /**
     * @param argument Inspect all query arguments.
     */
    @JvmName("dwlmwtcovucqotua")
    public suspend
    fun allQueryArguments(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allQueryArguments = mapped
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("wyeqptlwscscyxit")
    public suspend
    fun body(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param argument Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("somefvamldbvdxcu")
    public suspend
    fun body(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.body = mapped
    }

    /**
     * @param value Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("qvrxoyxdqcxblnkc")
    public suspend
    fun cookies(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("pjxprwkfqmghojre")
    public suspend
    fun cookies(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    /**
     * @param value Inspect the request headers. See Headers below for details.
     */
    @JvmName("qqgxxosjkimobgeg")
    public suspend
    fun headers(`value`: List<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("iekmdktlnamghrjp")
    public suspend
    fun headers(argument: List<suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("dvncdrfacvuavhmo")
    public suspend fun headers(
        vararg
        argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("mdamdricrkkraekn")
    public suspend
    fun headers(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Inspect the request headers. See Headers below for details.
     */
    @JvmName("bwxxgpqqqxhagaeh")
    public suspend fun headers(
        vararg
        values: RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchHeaderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value
     */
    @JvmName("ncgtwonsbjtqyxll")
    public suspend
    fun ja3Fingerprint(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchJa3FingerprintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ja3Fingerprint = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ciehrmqpfpuxlgrk")
    public suspend
    fun ja3Fingerprint(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchJa3FingerprintArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchJa3FingerprintArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ja3Fingerprint = mapped
    }

    /**
     * @param value Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("niqudxnrxthnsfpk")
    public suspend
    fun jsonBody(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchJsonBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonBody = mapped
    }

    /**
     * @param argument Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("tuiilfmfccebhloo")
    public suspend
    fun jsonBody(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchJsonBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchJsonBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonBody = mapped
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("pwpptqpmegfxingu")
    public suspend
    fun method(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param argument Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("shbwgqxufwlljjge")
    public suspend
    fun method(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.method = mapped
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("jvkbreuobivfnfni")
    public suspend
    fun queryString(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("puiadugqdaldedqs")
    public suspend
    fun queryString(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Inspect a single header. See Single Header below for details.
     */
    @JvmName("omiwbwnrpdqrqmvg")
    public suspend
    fun singleHeader(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchSingleHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeader = mapped
    }

    /**
     * @param argument Inspect a single header. See Single Header below for details.
     */
    @JvmName("ivdwfnwktrxubkuf")
    public suspend
    fun singleHeader(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchSingleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchSingleHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleHeader = mapped
    }

    /**
     * @param value Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("gwolrkwkyhmpsfqu")
    public suspend
    fun singleQueryArgument(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchSingleQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleQueryArgument = mapped
    }

    /**
     * @param argument Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("qfbdpkisixhljiuy")
    public suspend
    fun singleQueryArgument(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleQueryArgument = mapped
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("dfojvhdujaswupmt")
    public suspend
    fun uriPath(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("ngluxdbpumsxkcey")
    public suspend
    fun uriPath(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build():
        RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchArgs =
        RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatchArgs(
            allQueryArguments = allQueryArguments,
            body = body,
            cookies = cookies,
            headers = headers,
            ja3Fingerprint = ja3Fingerprint,
            jsonBody = jsonBody,
            method = method,
            queryString = queryString,
            singleHeader = singleHeader,
            singleQueryArgument = singleQueryArgument,
            uriPath = uriPath,
        )
}
