@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property countryCodes An array of two-character country codes, for example, [ "US", "CN" ], from the alpha-2 country ISO codes of the `ISO 3166` international standard&#46; See the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchStatement.html) for valid values.
 * @property forwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See Forwarded IP Config below for details.
 */
public data class RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgs(
    public val countryCodes: Output<List<String>>,
    public val forwardedIpConfig:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgs.builder()
            .countryCodes(countryCodes.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .forwardedIpConfig(
                forwardedIpConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgsBuilder
internal constructor() {
    private var countryCodes: Output<List<String>>? = null

    private var forwardedIpConfig:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgs>? =
        null

    /**
     * @param value An array of two-character country codes, for example, [ "US", "CN" ], from the alpha-2 country ISO codes of the `ISO 3166` international standard&#46; See the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchStatement.html) for valid values.
     */
    @JvmName("xcdqyccpgqwfwtqa")
    public suspend fun countryCodes(`value`: Output<List<String>>) {
        this.countryCodes = value
    }

    @JvmName("funkvqmbifeyeyce")
    public suspend fun countryCodes(vararg values: Output<String>) {
        this.countryCodes = Output.all(values.asList())
    }

    /**
     * @param values An array of two-character country codes, for example, [ "US", "CN" ], from the alpha-2 country ISO codes of the `ISO 3166` international standard&#46; See the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchStatement.html) for valid values.
     */
    @JvmName("ausmcatqsiihxely")
    public suspend fun countryCodes(values: List<Output<String>>) {
        this.countryCodes = Output.all(values)
    }

    /**
     * @param value The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See Forwarded IP Config below for details.
     */
    @JvmName("psbcittjmkrqfsfr")
    public suspend
    fun forwardedIpConfig(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgs>) {
        this.forwardedIpConfig = value
    }

    /**
     * @param value An array of two-character country codes, for example, [ "US", "CN" ], from the alpha-2 country ISO codes of the `ISO 3166` international standard&#46; See the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchStatement.html) for valid values.
     */
    @JvmName("kpnrhbbdnyhtvtmd")
    public suspend fun countryCodes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.countryCodes = mapped
    }

    /**
     * @param values An array of two-character country codes, for example, [ "US", "CN" ], from the alpha-2 country ISO codes of the `ISO 3166` international standard&#46; See the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchStatement.html) for valid values.
     */
    @JvmName("whuacbvytlpaooja")
    public suspend fun countryCodes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.countryCodes = mapped
    }

    /**
     * @param value The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See Forwarded IP Config below for details.
     */
    @JvmName("ytsmjdepaucyfjgg")
    public suspend
    fun forwardedIpConfig(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedIpConfig = mapped
    }

    /**
     * @param argument The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See Forwarded IP Config below for details.
     */
    @JvmName("ywvxnoyoghgfwise")
    public suspend
    fun forwardedIpConfig(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.forwardedIpConfig = mapped
    }

    internal fun build():
        RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgs =
        RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgs(
            countryCodes = countryCodes ?: throw PulumiNullFieldException("countryCodes"),
            forwardedIpConfig = forwardedIpConfig,
        )
}
