@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fallbackBehavior The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. Valid values include: `MATCH` or `NO_MATCH`.
 * @property headerName The name of the HTTP header to use for the IP address.
 */
public data class
RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgs(
    public val fallbackBehavior: Output<String>,
    public val headerName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgs.builder()
            .fallbackBehavior(fallbackBehavior.applyValue({ args0 -> args0 }))
            .headerName(headerName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgs].
 */
@PulumiTagMarker
public class
RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgsBuilder
internal constructor() {
    private var fallbackBehavior: Output<String>? = null

    private var headerName: Output<String>? = null

    /**
     * @param value The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. Valid values include: `MATCH` or `NO_MATCH`.
     */
    @JvmName("dlvojkpdkrqylxsr")
    public suspend fun fallbackBehavior(`value`: Output<String>) {
        this.fallbackBehavior = value
    }

    /**
     * @param value The name of the HTTP header to use for the IP address.
     */
    @JvmName("lcngivqsrsxwqnxt")
    public suspend fun headerName(`value`: Output<String>) {
        this.headerName = value
    }

    /**
     * @param value The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. Valid values include: `MATCH` or `NO_MATCH`.
     */
    @JvmName("fvxaylqibnhhkqbm")
    public suspend fun fallbackBehavior(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fallbackBehavior = mapped
    }

    /**
     * @param value The name of the HTTP header to use for the IP address.
     */
    @JvmName("ibwdmamsepswwkwn")
    public suspend fun headerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerName = mapped
    }

    internal fun build():
        RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgs =
        RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgs(
            fallbackBehavior = fallbackBehavior ?: throw PulumiNullFieldException("fallbackBehavior"),
            headerName = headerName ?: throw PulumiNullFieldException("headerName"),
        )
}
