@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers.
 * @property cookies Inspect the cookies in the web request. See Cookies below for details.
 * @property headers Inspect the request headers. See Headers below for details.
 * @property ja3Fingerprint
 * @property jsonBody Inspect the request body as JSON. See JSON Body for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See Single Header below for details.
 * @property singleQueryArgument Inspect a single query argument. See Single Query Argument below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class
RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchArgs(
    public val allQueryArguments:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgs>? =
        null,
    public val body:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchBodyArgs>? =
        null,
    public val cookies:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchCookiesArgs>? =
        null,
    public val headers:
    Output<List<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchHeaderArgs>>? =
        null,
    public val ja3Fingerprint:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgs>? =
        null,
    public val jsonBody:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchJsonBodyArgs>? =
        null,
    public val method:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchMethodArgs>? =
        null,
    public val queryString:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchQueryStringArgs>? =
        null,
    public val singleHeader:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs>? =
        null,
    public val singleQueryArgument:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgs>? =
        null,
    public val uriPath:
    Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchUriPathArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchArgs> {
    override fun toJava():
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchArgs.builder()
            .allQueryArguments(allQueryArguments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ja3Fingerprint(ja3Fingerprint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jsonBody(jsonBody?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleHeader(singleHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleQueryArgument(
                singleQueryArgument?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchArgs].
 */
@PulumiTagMarker
public class
RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchArgsBuilder
internal constructor() {
    private var allQueryArguments:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgs>? =
        null

    private var body:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchBodyArgs>? =
        null

    private var cookies:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchCookiesArgs>? =
        null

    private var headers:
        Output<List<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchHeaderArgs>>? =
        null

    private var ja3Fingerprint:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgs>? =
        null

    private var jsonBody:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchJsonBodyArgs>? =
        null

    private var method:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchMethodArgs>? =
        null

    private var queryString:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchQueryStringArgs>? =
        null

    private var singleHeader:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs>? =
        null

    private var singleQueryArgument:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgs>? =
        null

    private var uriPath:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchUriPathArgs>? =
        null

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("uojoiqawskkhnxej")
    public suspend
    fun allQueryArguments(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgs>) {
        this.allQueryArguments = value
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("reneikbnmvmcrejj")
    public suspend
    fun body(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchBodyArgs>) {
        this.body = value
    }

    /**
     * @param value Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("dvqiwcwvkcomfrsw")
    public suspend
    fun cookies(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Inspect the request headers. See Headers below for details.
     */
    @JvmName("suvcumofdugdtbrv")
    public suspend
    fun headers(`value`: Output<List<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("xrryljwygthgtxug")
    public suspend fun headers(
        vararg
        values: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchHeaderArgs>,
    ) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See Headers below for details.
     */
    @JvmName("cpqpjmaubyvntwwn")
    public suspend
    fun headers(values: List<Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("vjgiqksiuivkglog")
    public suspend
    fun ja3Fingerprint(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgs>) {
        this.ja3Fingerprint = value
    }

    /**
     * @param value Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("yptacncofxtjgknd")
    public suspend
    fun jsonBody(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchJsonBodyArgs>) {
        this.jsonBody = value
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("whxhrrjjudbfxusu")
    public suspend
    fun method(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchMethodArgs>) {
        this.method = value
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("cyjrkbdkppddaihp")
    public suspend
    fun queryString(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Inspect a single header. See Single Header below for details.
     */
    @JvmName("budbvqgokuwankon")
    public suspend
    fun singleHeader(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs>) {
        this.singleHeader = value
    }

    /**
     * @param value Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("wrlfudfmqhqduikn")
    public suspend
    fun singleQueryArgument(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgs>) {
        this.singleQueryArgument = value
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("wiobswpnyigljqtf")
    public suspend
    fun uriPath(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("hvxbkcguiacxmndk")
    public suspend
    fun allQueryArguments(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allQueryArguments = mapped
    }

    /**
     * @param argument Inspect all query arguments.
     */
    @JvmName("gvyblatjinshmsml")
    public suspend
    fun allQueryArguments(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allQueryArguments = mapped
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("snfljxgkqdfwippw")
    public suspend
    fun body(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param argument Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("dcqynnmlqkokdcqq")
    public suspend
    fun body(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.body = mapped
    }

    /**
     * @param value Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("fcqroqksfsxeawkw")
    public suspend
    fun cookies(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("dkmnsvruwhceloak")
    public suspend
    fun cookies(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    /**
     * @param value Inspect the request headers. See Headers below for details.
     */
    @JvmName("bykwwgkixhhyfuvy")
    public suspend
    fun headers(`value`: List<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("ofkomxoanbbokxyw")
    public suspend
    fun headers(argument: List<suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("tweniodipfrhsyeu")
    public suspend fun headers(
        vararg
        argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("gpujxcdljgxdqqrv")
    public suspend
    fun headers(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Inspect the request headers. See Headers below for details.
     */
    @JvmName("avexluqcjgidmcve")
    public suspend fun headers(
        vararg
        values: RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchHeaderArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value
     */
    @JvmName("edrmpitjwmoflpok")
    public suspend
    fun ja3Fingerprint(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ja3Fingerprint = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wvnloixgadopdsro")
    public suspend
    fun ja3Fingerprint(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ja3Fingerprint = mapped
    }

    /**
     * @param value Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("otofwbmvfbqymyhb")
    public suspend
    fun jsonBody(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchJsonBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonBody = mapped
    }

    /**
     * @param argument Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("helhivesmwvevcpl")
    public suspend
    fun jsonBody(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchJsonBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchJsonBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonBody = mapped
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("ycsbgxpmqamljfkd")
    public suspend
    fun method(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param argument Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("avftyjhrybaayxff")
    public suspend
    fun method(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.method = mapped
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("ilsxnjteryhewtrk")
    public suspend
    fun queryString(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("yxjebudnkpwxktsh")
    public suspend
    fun queryString(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Inspect a single header. See Single Header below for details.
     */
    @JvmName("rkbixstvhdaoampo")
    public suspend
    fun singleHeader(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeader = mapped
    }

    /**
     * @param argument Inspect a single header. See Single Header below for details.
     */
    @JvmName("cavsssnrvumuccbw")
    public suspend
    fun singleHeader(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchSingleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchSingleHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleHeader = mapped
    }

    /**
     * @param value Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("hsirrglrnxulhiho")
    public suspend
    fun singleQueryArgument(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleQueryArgument = mapped
    }

    /**
     * @param argument Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("akrurcdmknpnwvyp")
    public suspend
    fun singleQueryArgument(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleQueryArgument = mapped
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("djrifauhyxksvkvq")
    public suspend
    fun uriPath(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("mhyxjsoyugyjbyuu")
    public suspend
    fun uriPath(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build():
        RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchArgs =
        RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementFieldToMatchArgs(
            allQueryArguments = allQueryArguments,
            body = body,
            cookies = cookies,
            headers = headers,
            ja3Fingerprint = ja3Fingerprint,
            jsonBody = jsonBody,
            method = method,
            queryString = queryString,
            singleHeader = singleHeader,
            singleQueryArgument = singleQueryArgument,
            uriPath = uriPath,
        )
}
